/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.scripting.impl;

import java.util.Map;
import javax.enterprise.inject.Typed;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.myfaces.extensions.cdi.core.api.UnhandledException;
import org.apache.myfaces.extensions.cdi.scripting.api.ScriptExecutor;
import org.apache.myfaces.extensions.cdi.scripting.api.language.Language;
import org.apache.myfaces.extensions.cdi.scripting.impl.spi.ExternalExpressionInterpreter;
import org.apache.myfaces.extensions.cdi.scripting.impl.util.ScriptingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
class DefaultScriptExecutor
implements ScriptExecutor {
    private static final long serialVersionUID = 1340953486786561148L;
    private transient ScriptEngine scriptEngine;
    private Class<? extends Language> language;

    DefaultScriptExecutor(ScriptEngine scriptEngine, Class<? extends Language> language) {
        this.scriptEngine = scriptEngine;
        this.language = language;
    }

    public Object eval(String script) {
        return this.eval(script, Object.class);
    }

    public Object eval(String script, Map<String, Object> arguments) {
        return this.eval(script, arguments, Object.class);
    }

    public Object eval(String script, Bindings bindings) {
        return this.eval(script, bindings, Object.class);
    }

    public <T> T eval(String script, Class<T> returnType) {
        try {
            script = this.interpreteScript(script);
            return (T)this.getScriptEngine().eval(script);
        }
        catch (ScriptException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private ScriptEngine getScriptEngine() {
        if (this.scriptEngine == null) {
            this.scriptEngine = ScriptingUtils.createScriptEngine(this.language);
        }
        return this.scriptEngine;
    }

    public <T> T eval(String script, Map<String, Object> arguments, Class<T> returnType) {
        return this.eval(script, new SimpleBindings(arguments), returnType);
    }

    public <T> T eval(String script, Bindings bindings, Class<T> returnType) {
        try {
            script = this.interpreteScript(script);
            return (T)this.getScriptEngine().eval(script, bindings);
        }
        catch (ScriptException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private String interpreteScript(String script) {
        ExternalExpressionInterpreter externalExpressionInterpreter = ScriptingUtils.resolveExternalExpressionInterpreter();
        return externalExpressionInterpreter.transform(script);
    }
}

