/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.scripting.impl;

import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.myfaces.extensions.cdi.core.api.UnhandledException;
import org.apache.myfaces.extensions.cdi.scripting.api.ScriptBuilder;
import org.apache.myfaces.extensions.cdi.scripting.api.language.Language;
import org.apache.myfaces.extensions.cdi.scripting.impl.spi.ExternalExpressionInterpreter;
import org.apache.myfaces.extensions.cdi.scripting.impl.util.ExceptionUtils;
import org.apache.myfaces.extensions.cdi.scripting.impl.util.ScriptingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultScriptBuilder
implements ScriptBuilder {
    private static final long serialVersionUID = -7746031361776472273L;
    private transient ScriptEngine scriptEngine;
    private Class<? extends Language> language;
    private transient Map<String, Object> arguments;
    private transient String script;
    private transient Bindings bindings;

    private DefaultScriptBuilder() {
    }

    DefaultScriptBuilder(ScriptEngine scriptEngine, Class<? extends Language> language) {
        this.scriptEngine = scriptEngine;
        this.language = language;
    }

    public ScriptBuilder script(String script) {
        DefaultScriptBuilder newScriptBuilder = new DefaultScriptBuilder(this.getScriptEngine(), this.language);
        newScriptBuilder.script = script;
        return newScriptBuilder;
    }

    public ScriptBuilder namedArgument(String name, Object value) {
        if (this.bindings != null) {
            throw ExceptionUtils.overrideBuilderState("(named) argument/s");
        }
        if (this.arguments == null) {
            this.arguments = new HashMap<String, Object>();
        }
        this.arguments.put(name, value);
        return this;
    }

    public ScriptBuilder bindings(Bindings bindings) {
        if (this.arguments != null) {
            throw ExceptionUtils.overrideBuilderState("bindings");
        }
        this.bindings = bindings;
        return this;
    }

    public Object eval() {
        return this.eval(Object.class);
    }

    public <T> T eval(Class<T> returnType) {
        try {
            this.script = this.interpreteScript(this.script);
            if (this.bindings == null && this.arguments == null) {
                return (T)this.getScriptEngine().eval(this.script);
            }
            Bindings scriptBindings = this.bindings;
            if (scriptBindings == null) {
                scriptBindings = new SimpleBindings(this.arguments);
            }
            return (T)this.getScriptEngine().eval(this.script, scriptBindings);
        }
        catch (ScriptException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private String interpreteScript(String script) {
        ExternalExpressionInterpreter externalExpressionInterpreter = ScriptingUtils.resolveExternalExpressionInterpreter();
        return externalExpressionInterpreter.transform(script);
    }

    private ScriptEngine getScriptEngine() {
        if (this.scriptEngine == null) {
            this.scriptEngine = ScriptingUtils.createScriptEngine(this.language);
        }
        return this.scriptEngine;
    }
}

