/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.bv;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.validation.MessageInterpolator;
import org.apache.myfaces.extensions.cdi.jsf.api.Jsf;
import org.apache.myfaces.extensions.cdi.message.api.MessageContext;
import org.apache.myfaces.extensions.cdi.message.impl.NamedArguments;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public class InvalidValueAwareMessageInterpolator
implements MessageInterpolator {
    private static final String INVALID_VALUE_KEY = "invalidValue";
    private static final Logger LOGGER = Logger.getLogger(InvalidValueAwareMessageInterpolator.class.getName());
    private MessageInterpolator wrapped;
    @Inject
    @Jsf
    private MessageContext messageContext;

    protected InvalidValueAwareMessageInterpolator() {
    }

    public InvalidValueAwareMessageInterpolator(MessageInterpolator messageInterpolator) {
        this.wrapped = messageInterpolator;
    }

    public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
        return this.interpolate(messageTemplate, context, null);
    }

    public String interpolate(String messageTemplate, MessageInterpolator.Context context, Locale locale) {
        Map<String, Serializable> attributes = new HashMap<String, Serializable>();
        String separator = "$org.apache.myfaces.extensions.cdi$";
        boolean classLevelViolation = messageTemplate.contains(separator);
        if (classLevelViolation) {
            int index = messageTemplate.indexOf(separator);
            this.addInvalidValue(attributes, (Serializable)((Object)messageTemplate.substring(0, index)));
            messageTemplate = messageTemplate.substring(index + separator.length());
        } else {
            attributes = this.buildAttributes(context, attributes, classLevelViolation);
        }
        if (attributes == null) {
            return this.wrapped.interpolate(messageTemplate, context, this.messageContext.getLocale());
        }
        String result = this.messageContext.message().text(messageTemplate).argument(NamedArguments.convert(attributes)).toText();
        if (messageTemplate.equals(result) || result != null && result.startsWith("???")) {
            return this.wrapped.interpolate(messageTemplate, context, this.messageContext.getLocale());
        }
        return result;
    }

    private Map<String, Serializable> buildAttributes(MessageInterpolator.Context context, Map<String, Serializable> attributes, boolean classLevelViolation) {
        attributes.putAll(this.getCustomAttributesOfConstraint(context.getConstraintDescriptor().getAttributes()));
        if (!classLevelViolation && attributes.containsKey(INVALID_VALUE_KEY)) {
            this.logWarning(context);
            return null;
        }
        this.addInvalidValue(attributes, (Serializable)context.getValidatedValue());
        return attributes;
    }

    private void logWarning(MessageInterpolator.Context context) {
        String constraintName = context.getConstraintDescriptor().getAnnotation().annotationType().getName();
        String warnMessage = constraintName + " uses 'invalidValue' as custom constraint attribute." + "So it isn't possible to use it as implicit key in the violation message.";
        LOGGER.warning(warnMessage);
    }

    private Map<String, Serializable> getCustomAttributesOfConstraint(Map<String, Object> attributesOfConstraint) {
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        for (Map.Entry<String, Object> entry : attributesOfConstraint.entrySet()) {
            if (!this.allowAttributeForMessageInterpolation(entry)) continue;
            attributes.put(entry.getKey(), (Serializable)entry.getValue());
        }
        return attributes;
    }

    private void addInvalidValue(Map<String, Serializable> attributes, Serializable invalidValue) {
        if (invalidValue != null) {
            attributes.put(INVALID_VALUE_KEY, invalidValue);
        } else {
            attributes.put(INVALID_VALUE_KEY, (Serializable)((Object)"null"));
        }
    }

    private boolean allowAttributeForMessageInterpolation(Map.Entry<String, Object> entry) {
        return entry.getValue() instanceof Serializable && !"groups".equals(entry.getKey()) && !"payload".equals(entry.getKey()) && !"message".equals(entry.getKey());
    }
}

