/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl;

import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.cdi.core.api.activation.Deactivatable;
import org.apache.myfaces.extensions.cdi.core.impl.util.ClassDeactivation;
import org.apache.myfaces.extensions.cdi.jsf.impl.scope.conversation.WindowContextAwareViewHandler;
import org.apache.myfaces.extensions.cdi.jsf.impl.security.SecurityAwareViewHandler;

public class CodiViewHandler
extends ViewHandlerWrapper
implements Deactivatable {
    protected ViewHandler wrapped;
    private ViewHandler windowContextAwareViewHandler;
    private ViewHandler securityAwareViewHandler;

    public CodiViewHandler(ViewHandler wrapped) {
        this.wrapped = wrapped;
        if (this.isActivated()) {
            this.windowContextAwareViewHandler = new WindowContextAwareViewHandler(this.wrapped);
            this.securityAwareViewHandler = this.createSecurityAwareViewHandler();
        }
    }

    protected ViewHandler createSecurityAwareViewHandler() {
        return new SecurityAwareViewHandler(this.wrapped);
    }

    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        if (this.securityAwareViewHandler == null) {
            return this.wrapped.createView(facesContext, viewId);
        }
        return this.securityAwareViewHandler.createView(facesContext, viewId);
    }

    public String getActionURL(FacesContext facesContext, String viewId) {
        if (this.windowContextAwareViewHandler == null) {
            return this.wrapped.getActionURL(facesContext, viewId);
        }
        return this.windowContextAwareViewHandler.getActionURL(facesContext, viewId);
    }

    public UIViewRoot restoreView(FacesContext facesContext, String viewId) {
        if (this.windowContextAwareViewHandler == null) {
            return this.wrapped.restoreView(facesContext, viewId);
        }
        return this.windowContextAwareViewHandler.restoreView(facesContext, viewId);
    }

    public ViewHandler getWrapped() {
        return this.wrapped;
    }

    public boolean isActivated() {
        return ClassDeactivation.isClassActivated(((Object)((Object)this)).getClass());
    }
}

