/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.message.impl;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.extensions.cdi.message.api.Formatter;
import org.apache.myfaces.extensions.cdi.message.api.FormatterFactory;
import org.apache.myfaces.extensions.cdi.message.api.GenericConfig;
import org.apache.myfaces.extensions.cdi.message.impl.FormatterConfigKey;
import org.apache.myfaces.extensions.cdi.message.impl.formatter.FormatterBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFormatterFactory
implements FormatterFactory {
    private static final long serialVersionUID = -7462205386564870045L;
    private static final Logger LOGGER = Logger.getLogger(DefaultFormatterFactory.class.getName());
    private CopyOnWriteArrayList<Formatter> formatters = new CopyOnWriteArrayList();
    private ConcurrentHashMap<Class<?>, Formatter> formatterCache = null;
    private ConcurrentHashMap<FormatterConfigKey, GenericConfig> formatterConfigs = new ConcurrentHashMap();

    public synchronized FormatterFactory add(Formatter formatter) {
        if (!this.formatters.contains(formatter)) {
            this.formatters.add(formatter);
            if (this.formatterCache != null) {
                this.formatterCache.clear();
            }
        }
        return this;
    }

    public synchronized List<Formatter> reset() {
        List<Formatter> oldFormatters = Collections.unmodifiableList(this.formatters);
        this.formatters.clear();
        return oldFormatters;
    }

    public Formatter findFormatter(Class<?> type) {
        Formatter found;
        if (this.formatterCache != null && this.formatterCache.containsKey(type)) {
            return this.formatterCache.get(type);
        }
        if (this.formatterCache == null) {
            this.formatterCache = new ConcurrentHashMap();
        }
        if ((found = this.findFormatterFor(type)) == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("default formatter used for: " + type.getName());
            }
            found = FormatterBuilder.createFormatter(type);
        }
        if (found.isStateless()) {
            this.formatterCache.put(type, found);
        }
        return found;
    }

    public FormatterFactory addFormatterConfig(Class<?> type, GenericConfig formatterConfig) {
        this.addFormatterConfig(type, formatterConfig, Locale.getDefault());
        return this;
    }

    public FormatterFactory addFormatterConfig(Class<?> type, GenericConfig formatterConfig, Locale locale) {
        if (formatterConfig.containsProperty(Locale.class.getName())) {
            locale = (Locale)formatterConfig.getProperty(Locale.class.getName(), Locale.class);
        }
        this.formatterConfigs.put(this.createKey(type, locale), formatterConfig);
        return this;
    }

    public GenericConfig findFormatterConfig(Class<?> type, Locale locale) {
        return this.formatterConfigs.get(this.createKey(type, locale));
    }

    private Formatter findFormatterFor(Class<?> type) {
        for (Formatter formatter : this.formatters) {
            if (!formatter.isResponsibleFor(type)) continue;
            return formatter;
        }
        return null;
    }

    private FormatterConfigKey createKey(Class<?> type, Locale locale) {
        return new FormatterConfigKey(type, locale);
    }
}

