/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jpa.impl;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Typed;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;
import org.apache.myfaces.extensions.cdi.jpa.impl.EntityManagerEntry;
import org.apache.myfaces.extensions.cdi.jpa.impl.PersistenceContextMetaEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public class PersistenceHelper {
    private static final String NO_FIELD_MARKER = PersistenceHelper.class.getName() + ":DEFAULT_FIELD";
    private static volatile transient Map<ClassLoader, Map<String, PersistenceContextMetaEntry>> persistenceContextMetaEntries = new ConcurrentHashMap<ClassLoader, Map<String, PersistenceContextMetaEntry>>();

    private PersistenceHelper() {
    }

    public static EntityManager tryToFindEntityManagerReference(Object target) {
        EntityManagerEntry entityManagerEntry = PersistenceHelper.tryToFindEntityManagerEntryInTarget(target);
        if (entityManagerEntry == null) {
            return null;
        }
        return entityManagerEntry.getEntityManager();
    }

    static EntityManagerEntry tryToFindEntityManagerEntryInTarget(Object target) {
        Field entityManagerField;
        String key;
        Map<String, PersistenceContextMetaEntry> mapping = persistenceContextMetaEntries.get(PersistenceHelper.getClassLoader());
        PersistenceContextMetaEntry persistenceContextEntry = (mapping = PersistenceHelper.initMapping(mapping)).get(key = target.getClass().getName());
        if (persistenceContextEntry != null && NO_FIELD_MARKER.equals(persistenceContextEntry.getFieldName())) {
            return null;
        }
        if (persistenceContextEntry == null) {
            persistenceContextEntry = PersistenceHelper.findPersistenceContextEntry(target.getClass());
            if (persistenceContextEntry == null) {
                mapping.put(key, new PersistenceContextMetaEntry(Object.class, NO_FIELD_MARKER, Default.class.getName(), false));
                return null;
            }
            mapping.put(key, persistenceContextEntry);
        }
        try {
            entityManagerField = persistenceContextEntry.getSourceClass().getDeclaredField(persistenceContextEntry.getFieldName());
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        entityManagerField.setAccessible(true);
        try {
            EntityManager entityManager = (EntityManager)entityManagerField.get(target);
            return new EntityManagerEntry(entityManager, persistenceContextEntry);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private static synchronized Map<String, PersistenceContextMetaEntry> initMapping(Map<String, PersistenceContextMetaEntry> mapping) {
        if (mapping == null) {
            mapping = new ConcurrentHashMap<String, PersistenceContextMetaEntry>();
            persistenceContextMetaEntries.put(PersistenceHelper.getClassLoader(), mapping);
        }
        return mapping;
    }

    private static PersistenceContextMetaEntry findPersistenceContextEntry(Class target) {
        for (Class currentParamClass = target; currentParamClass != null && !Object.class.getName().equals(currentParamClass.getName()); currentParamClass = currentParamClass.getSuperclass()) {
            for (Field currentField : currentParamClass.getDeclaredFields()) {
                PersistenceContext persistenceContext = currentField.getAnnotation(PersistenceContext.class);
                if (persistenceContext == null) continue;
                return new PersistenceContextMetaEntry(currentParamClass, currentField.getName(), persistenceContext.unitName(), PersistenceContextType.EXTENDED.equals((Object)persistenceContext.type()));
            }
        }
        return null;
    }

    private static ClassLoader getClassLoader() {
        return ClassUtils.getClassLoader(null);
    }
}

