/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.message;

import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.JsfUtils;
import org.apache.myfaces.extensions.cdi.message.api.MessageContext;
import org.apache.myfaces.extensions.cdi.message.api.MessageResolver;
import org.apache.myfaces.extensions.cdi.message.api.payload.MessagePayload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JsfAwareApplicationMessagesMessageResolver
implements MessageResolver {
    private static final long serialVersionUID = 4646223879356055470L;

    JsfAwareApplicationMessagesMessageResolver() {
    }

    public String getMessage(MessageContext messageContext, String messageDescriptor, Map<Class, MessagePayload> messagePayload) {
        if (!this.isKey(messageDescriptor)) {
            return messageDescriptor;
        }
        try {
            messageDescriptor = this.extractKey(messageDescriptor);
            ResourceBundle resourceBundle = JsfUtils.getCustomFacesMessageBundle(messageContext.getLocale());
            if (resourceBundle == null) {
                return this.defaultFacesMessage(messageDescriptor, messageContext.getLocale());
            }
            return resourceBundle.getString(messageDescriptor);
        }
        catch (MissingResourceException e) {
            return this.defaultFacesMessage(messageDescriptor, messageContext.getLocale());
        }
    }

    private boolean isKey(String key) {
        return key.startsWith("{") && key.endsWith("}");
    }

    private String extractKey(String key) {
        return key.substring(1, key.length() - 1);
    }

    private String defaultFacesMessage(String messageDescriptor, Locale locale) {
        try {
            return JsfUtils.getDefaultFacesMessageBundle(locale).getString(messageDescriptor);
        }
        catch (MissingResourceException e) {
            return messageDescriptor;
        }
    }
}

