/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.model;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import jakarta.faces.model.DataModel;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.cdi.util.CDIUtils;

@ApplicationScoped
public class FacesDataModelManager {
    private volatile Map<Class<?>, Class<? extends DataModel>> facesDataModels = null;

    public Map<Class<?>, Class<? extends DataModel>> getFacesDataModels() {
        if (this.facesDataModels == null) {
            return Collections.emptyMap();
        }
        return this.facesDataModels;
    }

    public void addFacesDataModel(Class<?> forClass, Class<? extends DataModel> dataModelClass) {
        if (this.facesDataModels == null) {
            this.facesDataModels = new ConcurrentHashMap();
        }
        this.facesDataModels.put(forClass, dataModelClass);
    }

    public void init() {
        if (this.facesDataModels != null) {
            this.facesDataModels = Collections.unmodifiableMap(this.facesDataModels);
        }
    }

    public void reset() {
        this.facesDataModels = null;
    }

    public DataModel tryToCreateDataModel(FacesContext facesContext, Class<?> forClass, Object value) {
        if (this.facesDataModels == null) {
            return null;
        }
        Class<? extends DataModel> dataModelClass = this.facesDataModels.get(forClass);
        if (dataModelClass != null) {
            return this.instantiate(forClass, value, dataModelClass);
        }
        Class<?> entryForClass = null;
        Class<? extends DataModel> valueForClass = null;
        for (Map.Entry<Class<?>, Class<DataModel>> entry : this.facesDataModels.entrySet()) {
            if (!entry.getKey().isAssignableFrom(forClass)) continue;
            if (entryForClass != null) {
                if (!entryForClass.isAssignableFrom(entry.getKey())) continue;
                entryForClass = entry.getKey();
                valueForClass = entry.getValue();
                continue;
            }
            entryForClass = entry.getKey();
            valueForClass = entry.getValue();
        }
        if (entryForClass != null) {
            return this.instantiate(forClass, value, valueForClass);
        }
        return null;
    }

    private DataModel instantiate(Class<?> forClass, Object value, Class<? extends DataModel> dataModelClass) {
        try {
            Constructor<DataModel<Object>> selectedConstructor = null;
            boolean equalsFound = false;
            for (Constructor<?> constructor : dataModelClass.getConstructors()) {
                if (constructor.getParameterCount() != 1) continue;
                if (constructor.getParameterTypes()[0].equals(forClass)) {
                    selectedConstructor = constructor;
                    equalsFound = true;
                    continue;
                }
                if (!constructor.getParameterTypes()[0].isAssignableFrom(forClass) || equalsFound) continue;
                selectedConstructor = constructor;
            }
            Constructor<? extends DataModel> constructor = null;
            if (selectedConstructor != null) {
                constructor = selectedConstructor;
                return constructor.newInstance(value);
            }
            constructor = dataModelClass.getConstructor(new Class[0]);
            DataModel dm = constructor.newInstance(new Object[0]);
            dm.setWrappedData(value);
            return dm;
        }
        catch (IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new FacesException("Cannot find constructor of DataModel with " + forClass.getName() + " as parameter", ex);
        }
        catch (IllegalAccessException | InstantiationException | SecurityException ex) {
            throw new FacesException("Cannot access constructor of DataModel with " + forClass.getName() + " as parameter", ex);
        }
    }

    public static DataModel createDataModel(FacesContext facesContext, Class<?> forClass, Object value) {
        BeanManager beanManager = CDIUtils.getBeanManager(facesContext);
        FacesDataModelManager facesDataModelManager = CDIUtils.get(beanManager, FacesDataModelManager.class);
        return facesDataModelManager.tryToCreateDataModel(facesContext, forClass, value);
    }
}

