/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.UICommand;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.FacesListener;
import jakarta.faces.validator.Validator;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DebugUtils {
    private static final Logger log = Logger.getLogger(DebugUtils.class.getName());
    private static final HashSet<String> IGNORE_ATTRIBUTES = new HashSet();
    private static final String JSF_COMPONENT_PACKAGE = "jakarta.faces.component.";
    private static final String MYFACES_COMPONENT_PACKAGE = "org.apache.myfaces.component.";

    private DebugUtils() {
    }

    public static void assertError(boolean condition, Logger logger, String msg) throws FacesException {
        if (!condition) {
            logger.severe(msg);
            throw new FacesException(msg);
        }
    }

    public static void assertFatal(boolean condition, Logger logger, String msg) throws FacesException {
        if (!condition) {
            logger.severe(msg);
            throw new FacesException(msg);
        }
    }

    public static void traceView(String additionalMsg) {
        if (log.isLoggable(Level.FINEST)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null) {
                log.severe("Cannot not print view to console (no FacesContext).");
                return;
            }
            UIViewRoot viewRoot = facesContext.getViewRoot();
            if (viewRoot == null) {
                log.severe("Cannot not print view to console (no ViewRoot in FacesContext).");
                return;
            }
            DebugUtils.traceView(additionalMsg, viewRoot);
        }
    }

    private static void traceView(String additionalMsg, UIViewRoot viewRoot) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        if (additionalMsg != null) {
            ps.println(additionalMsg);
        }
        ps.println("========================================");
        DebugUtils.printView(viewRoot, ps);
        ps.println("========================================");
        ps.close();
        log.finest(baos.toString());
    }

    public static void printView(UIViewRoot uiViewRoot, PrintStream stream) {
        DebugUtils.printComponent(uiViewRoot, stream, 0, true, null);
    }

    public static void printComponent(UIComponent comp, PrintStream stream) {
        DebugUtils.printComponent(comp, stream, 0, false, null);
    }

    private static void printComponent(UIComponent comp, PrintStream stream, int indent, boolean withChildrenAndFacets, String facetName) {
        int childCount;
        FacesListener listener;
        FacesListener[] listeners;
        BeanInfo beanInfo;
        DebugUtils.printIndent(stream, indent);
        stream.print('<');
        String compType = comp.getClass().getName();
        if (compType.startsWith(JSF_COMPONENT_PACKAGE)) {
            compType = compType.substring(JSF_COMPONENT_PACKAGE.length());
        } else if (compType.startsWith(MYFACES_COMPONENT_PACKAGE)) {
            compType = compType.substring(MYFACES_COMPONENT_PACKAGE.length());
        }
        stream.print(compType);
        DebugUtils.printAttribute(stream, "id", comp.getId());
        if (facetName != null) {
            DebugUtils.printAttribute(stream, "facetName", facetName);
        }
        for (Map.Entry<String, Object> entry : comp.getAttributes().entrySet()) {
            if ("id".equals(entry.getKey())) continue;
            DebugUtils.printAttribute(stream, entry.getKey(), entry.getValue());
        }
        try {
            beanInfo = Introspector.getBeanInfo(comp.getClass());
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        if (!compType.startsWith("org.apache.myfaces.view.facelets.compiler")) {
            PropertyDescriptor[] propDescriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propDescriptors.length; ++i) {
                String name;
                if (propDescriptors[i].getReadMethod() == null || "id".equals(name = propDescriptors[i].getName())) continue;
                ValueExpression ve = comp.getValueExpression(name);
                if (ve != null) {
                    DebugUtils.printAttribute(stream, name, ve.getExpressionString());
                    continue;
                }
                if (name.equals("value") && comp instanceof ValueHolder || IGNORE_ATTRIBUTES.contains(name)) continue;
                try {
                    Object value = comp.getAttributes().get(name);
                    DebugUtils.printAttribute(stream, name, value);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    DebugUtils.printAttribute(stream, name, null);
                }
            }
        }
        boolean mustClose = true;
        boolean nestedObjects = false;
        if (comp instanceof UICommand && (listeners = ((UICommand)comp).getActionListeners()) != null && listeners.length > 0) {
            nestedObjects = true;
            stream.println('>');
            mustClose = false;
            for (int i = 0; i < listeners.length; ++i) {
                listener = listeners[i];
                DebugUtils.printIndent(stream, indent + 1);
                stream.print('<');
                stream.print(listener.getClass().getName());
                stream.println("/>");
            }
        }
        if (comp instanceof UIInput) {
            Validator[] validators;
            listeners = ((UIInput)comp).getValueChangeListeners();
            if (listeners != null && listeners.length > 0) {
                nestedObjects = true;
                stream.println('>');
                mustClose = false;
                for (int i = 0; i < listeners.length; ++i) {
                    listener = listeners[i];
                    DebugUtils.printIndent(stream, indent + 1);
                    stream.print('<');
                    stream.print(listener.getClass().getName());
                    stream.println("/>");
                }
            }
            if ((validators = ((UIInput)comp).getValidators()) != null && validators.length > 0) {
                nestedObjects = true;
                stream.println('>');
                mustClose = false;
                for (int i = 0; i < validators.length; ++i) {
                    Validator validator = validators[i];
                    DebugUtils.printIndent(stream, indent + 1);
                    stream.print('<');
                    stream.print(validator.getClass().getName());
                    stream.println("/>");
                }
            }
        }
        if (withChildrenAndFacets && ((childCount = comp.getChildCount()) > 0 || comp.getFacetCount() > 0)) {
            Map<String, UIComponent> facetsMap = comp.getFacets();
            nestedObjects = true;
            if (mustClose) {
                stream.println('>');
                mustClose = false;
            }
            if (childCount > 0) {
                for (int i = 0; i < childCount; ++i) {
                    UIComponent child = comp.getChildren().get(i);
                    DebugUtils.printComponent(child, stream, indent + 1, true, null);
                }
            }
            for (Map.Entry<String, UIComponent> entry : facetsMap.entrySet()) {
                DebugUtils.printComponent(entry.getValue(), stream, indent + 1, true, entry.getKey());
            }
        }
        if (nestedObjects) {
            if (mustClose) {
                stream.println("/>");
            } else {
                DebugUtils.printIndent(stream, indent);
                stream.print("</");
                stream.print(compType);
                stream.println('>');
            }
        } else {
            stream.println("/>");
        }
    }

    private static void printAttribute(PrintStream stream, String name, Object value) {
        if (IGNORE_ATTRIBUTES.contains(name)) {
            return;
        }
        if (name.startsWith("jakarta.faces.webapp.UIComponentTag.")) {
            name = name.substring("jakarta.faces.webapp.UIComponentTag.".length());
        }
        stream.print(' ');
        stream.print(name);
        stream.print("=\"");
        if (value != null) {
            if (value instanceof UIComponent) {
                stream.print("[id:");
                stream.print(((UIComponent)value).getId());
                stream.print(']');
            } else if (value instanceof MethodExpression) {
                stream.print(((MethodExpression)value).getExpressionString());
            } else {
                stream.print(value.toString());
            }
        } else {
            stream.print("NULL");
        }
        stream.print('\"');
    }

    private static void printIndent(PrintStream stream, int depth) {
        for (int i = 0; i < depth; ++i) {
            stream.print("  ");
        }
    }

    public static String componentAsString(UIComponent comp) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DebugUtils.printComponent(comp, new PrintStream(baos));
            baos.close();
            return baos.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        IGNORE_ATTRIBUTES.add("attributes");
        IGNORE_ATTRIBUTES.add("children");
        IGNORE_ATTRIBUTES.add("childCount");
        IGNORE_ATTRIBUTES.add("class");
        IGNORE_ATTRIBUTES.add("facets");
        IGNORE_ATTRIBUTES.add("facetsAndChildren");
        IGNORE_ATTRIBUTES.add("parent");
        IGNORE_ATTRIBUTES.add("actionListeners");
        IGNORE_ATTRIBUTES.add("valueChangeListeners");
        IGNORE_ATTRIBUTES.add("validators");
        IGNORE_ATTRIBUTES.add("rowData");
        IGNORE_ATTRIBUTES.add("jakarta.faces.webapp.COMPONENT_IDS");
        IGNORE_ATTRIBUTES.add("jakarta.faces.webapp.FACET_NAMES");
        IGNORE_ATTRIBUTES.add("jakarta.faces.webapp.CURRENT_VIEW_ROOT");
        IGNORE_ATTRIBUTES.add("viewMap");
    }
}

