/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow.impl;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.flow.Flow;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.flow.FlowUtils;
import org.apache.myfaces.flow.impl.FlowScopeMap;
import org.apache.myfaces.spi.FacesFlowProvider;

public class DefaultFacesFlowProvider
extends FacesFlowProvider {
    private static final String FLOW_PREFIX = "oam.flow";
    static final String FLOW_SESSION_MAP_SUBKEY_PREFIX = "oam.flow.SCOPE";
    static final char SEPARATOR_CHAR = '.';
    private static final String CURRENT_FLOW_SCOPE_MAP = "oam.flow.SCOPE_MAP";

    @Override
    public Iterator<Flow> getAnnotatedFlows(FacesContext facesContext) {
        return null;
    }

    @Override
    public void doAfterEnterFlow(FacesContext facesContext, Flow flow) {
        String mapKey = this.getFlowKey(flow);
        facesContext.getAttributes().remove(mapKey);
    }

    @Override
    public void doBeforeExitFlow(FacesContext facesContext, Flow flow) {
        String flowMapKey = FlowUtils.getFlowMapKey(facesContext, flow);
        String fullToken = "oam.flow.SCOPE." + flowMapKey;
        String mapKey = this.getFlowKey(flow);
        Map map = (Map)facesContext.getAttributes().get(mapKey);
        if (map != null) {
            map.clear();
        } else {
            map = (Map)facesContext.getExternalContext().getSessionMap().get(fullToken);
            if (map != null) {
                map.clear();
            }
        }
        facesContext.getExternalContext().getSessionMap().remove(fullToken);
        facesContext.getAttributes().remove(mapKey);
    }

    @Override
    public Map<Object, Object> getCurrentFlowScope(FacesContext facesContext) {
        Flow flow = facesContext.getApplication().getFlowHandler().getCurrentFlow(facesContext);
        Map map = null;
        if (flow != null) {
            String mapKey = this.getFlowKey(flow);
            map = (Map)facesContext.getAttributes().get(mapKey);
            if (map == null) {
                String flowMapKey = FlowUtils.getFlowMapKey(facesContext, flow);
                map = new FlowScopeMap(this, flowMapKey);
                facesContext.getAttributes().put(mapKey, map);
            }
        }
        return map;
    }

    Map<Object, Object> createOrRestoreMap(FacesContext context, String prefix, boolean create) {
        ExternalContext external = context.getExternalContext();
        Map sessionMap = external.getSessionMap();
        ConcurrentHashMap map = (ConcurrentHashMap)sessionMap.get(prefix);
        if (map == null && create) {
            map = new ConcurrentHashMap();
            sessionMap.put(prefix, map);
        }
        return map;
    }

    protected String getFlowKey(Flow flow) {
        return "oam.flow.SCOPE_MAP." + flow.getDefiningDocumentId() + "." + flow.getId();
    }
}

