/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit;

import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.core.api.shared.lang.Assert;

public class RenderKitFactoryImpl
extends RenderKitFactory {
    private static final Logger log = Logger.getLogger(RenderKitFactoryImpl.class.getName());
    private Map<String, RenderKit> renderkits = new HashMap<String, RenderKit>();

    public void purgeRenderKit() {
        this.renderkits.clear();
    }

    public void addRenderKit(String renderKitId, RenderKit renderKit) {
        Assert.notNull((Object)renderKitId, (String)"renderKitId");
        Assert.notNull((Object)renderKit, (String)"renderKit");
        if (log.isLoggable(Level.INFO) && this.renderkits.containsKey(renderKitId)) {
            log.info("RenderKit with renderKitId '" + renderKitId + "' was replaced.");
        }
        this.renderkits.put(renderKitId, renderKit);
    }

    public RenderKit getRenderKit(FacesContext context, String renderKitId) throws FacesException {
        Assert.notNull((Object)renderKitId, (String)"renderKitId");
        RenderKit renderkit = this.renderkits.get(renderKitId);
        if (renderkit == null) {
            log.warning("Unknown RenderKit '" + renderKitId + "'.");
        }
        return renderkit;
    }

    public Iterator<String> getRenderKitIds() {
        return this.renderkits.keySet().iterator();
    }
}

