/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.util.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WebXmlParser {
    private static final Logger LOGGER = Logger.getLogger(WebXmlParser.class.getName());
    private static final String ERROR_PAGE_EXCEPTION_TYPE_EXPRESSION = "*[local-name() = 'error-page']/*[local-name() = 'exception-type']";
    private static final String LOCATION_EXPRESSION = "*[local-name() = 'location']";
    private static final String ERROR_CODE_500_LOCATION_EXPRESSION = "*[local-name() = 'error-page'][*[local-name() = 'error-code'] = '500'] / *[local-name() = 'location']";
    private static final String ERROR_PAGE_NO_CODE_AND_TYPE_EXPRESSION = "*[local-name() = 'error-page'][not(*[local-name() = 'error-code']) and not(*[local-name() = 'exception-type'])]/*[local-name() = 'location']";
    private static final String KEY_ERROR_PAGES = WebXmlParser.class.getName() + ".errorpages";

    private WebXmlParser() {
    }

    public static Map<String, String> getErrorPages(ExternalContext context) {
        Map cached;
        if (context != null && (cached = (Map)context.getApplicationMap().get(KEY_ERROR_PAGES)) != null) {
            return cached;
        }
        Map<String, String> webXmlErrorPages = WebXmlParser.getWebXmlErrorPages(context);
        Map<String, String> webFragmentXmlsErrorPages = WebXmlParser.getWebFragmentXmlsErrorPages();
        Map<String, String> errorPages = webXmlErrorPages;
        if (errorPages == null) {
            errorPages = webFragmentXmlsErrorPages;
        } else if (webFragmentXmlsErrorPages != null) {
            for (Map.Entry<String, String> entry : webFragmentXmlsErrorPages.entrySet()) {
                if (errorPages.containsKey(entry.getKey())) continue;
                errorPages.put(entry.getKey(), entry.getValue());
            }
        }
        if (context != null) {
            context.getApplicationMap().put(KEY_ERROR_PAGES, errorPages);
        }
        return errorPages;
    }

    private static Map<String, String> getWebXmlErrorPages(ExternalContext context) {
        try {
            Document webXml = null;
            if (context != null) {
                webXml = WebXmlParser.toDocument(context.getResource("/WEB-INF/web.xml"));
            }
            if (webXml == null) {
                webXml = WebXmlParser.toDocument(ClassUtils.getCurrentLoader(WebXmlParser.class).getResource("META-INF/web.xml"));
            }
            if (webXml != null) {
                return WebXmlParser.parseErrorPages(webXml.getDocumentElement());
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Could not load or parse web.xml", e);
        }
        return null;
    }

    private static Map<String, String> getWebFragmentXmlsErrorPages() {
        Map<String, String> webFragmentXmlsErrorPages = null;
        try {
            Enumeration<URL> webFragments = ClassUtils.getContextClassLoader().getResources("META-INF/web-fragment.xml");
            while (webFragments.hasMoreElements()) {
                try {
                    URL url = webFragments.nextElement();
                    Document webFragmentXml = WebXmlParser.toDocument(url);
                    if (webFragmentXml == null) continue;
                    if (webFragmentXmlsErrorPages == null) {
                        webFragmentXmlsErrorPages = WebXmlParser.parseErrorPages(webFragmentXml.getDocumentElement());
                        continue;
                    }
                    Map<String, String> temp = WebXmlParser.parseErrorPages(webFragmentXml.getDocumentElement());
                    for (Map.Entry<String, String> entry : temp.entrySet()) {
                        if (webFragmentXmlsErrorPages.containsKey(entry.getKey())) continue;
                        webFragmentXmlsErrorPages.put(entry.getKey(), entry.getValue());
                    }
                }
                catch (Throwable e) {
                    LOGGER.log(Level.SEVERE, "Could not load or parse web-fragment.xml", e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not get web-fragment.xml from ClassLoader", e);
        }
        return webFragmentXmlsErrorPages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document toDocument(URL url) throws Exception {
        Document document;
        InputStream is = null;
        if (url == null) {
            Document document2 = null;
            return document2;
        }
        is = url.openStream();
        if (is == null) {
            Document document3 = null;
            return document3;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        factory.setExpandEntityReferences(false);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        try {
            factory.setFeature("http://xml.org/sax/features/namespaces", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Throwable e) {
            LOGGER.warning("DocumentBuilderFactory#setFeature not implemented. Skipping...");
        }
        boolean absolute = false;
        try {
            absolute = url.toURI().isAbsolute();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (absolute) {
            InputSource source = new InputSource(url.toExternalForm());
            source.setByteStream(is);
            document = builder.parse(source);
        } else {
            document = builder.parse(is);
        }
        Document document4 = document;
        return document4;
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Map<String, String> parseErrorPages(Element webXml) throws Exception {
        HashMap<String, String> errorPages = new HashMap<String, String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList exceptionTypes = (NodeList)xpath.compile(ERROR_PAGE_EXCEPTION_TYPE_EXPRESSION).evaluate(webXml, XPathConstants.NODESET);
        for (int i = 0; i < exceptionTypes.getLength(); ++i) {
            Node node = exceptionTypes.item(i);
            String exceptionType = node.getTextContent().trim();
            String key = Throwable.class.getName().equals(exceptionType) ? null : exceptionType;
            String location = xpath.compile(LOCATION_EXPRESSION).evaluate(node.getParentNode()).trim();
            if (errorPages.containsKey(key)) continue;
            errorPages.put(key, location);
        }
        if (!errorPages.containsKey(null)) {
            String defaultLocation = xpath.compile(ERROR_CODE_500_LOCATION_EXPRESSION).evaluate(webXml).trim();
            if (StringUtils.isBlank(defaultLocation)) {
                defaultLocation = xpath.compile(ERROR_PAGE_NO_CODE_AND_TYPE_EXPRESSION).evaluate(webXml).trim();
            }
            if (!StringUtils.isBlank(defaultLocation)) {
                errorPages.put(null, defaultLocation);
            }
        }
        return errorPages;
    }
}

