/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf.core;

import java.io.IOException;
import java.io.Serializable;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;

public class PhaseListenerHandler
extends TagHandler {
    private final TagAttribute binding;
    private final String listenerType;

    public PhaseListenerHandler(TagConfig config) {
        super(config);
        TagAttribute type = this.getAttribute("type");
        this.binding = this.getAttribute("binding");
        if (type != null) {
            if (!type.isLiteral()) {
                throw new TagAttributeException(type, "Must be a literal class name of type PhaseListener");
            }
            try {
                ClassUtils.forName((String)type.getValue());
            }
            catch (ClassNotFoundException e) {
                throw new TagAttributeException(type, "Couldn't qualify PhaseListener", (Throwable)e);
            }
            this.listenerType = type.getValue();
        } else {
            this.listenerType = null;
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (ComponentHandler.isNew((UIComponent)parent)) {
            UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
            if (root == null) {
                throw new TagException(this.tag, "UIViewRoot not available");
            }
            ValueExpression b = null;
            if (this.binding != null) {
                b = this.binding.getValueExpression(ctx, PhaseListener.class);
            }
            LazyPhaseListener pl = new LazyPhaseListener(this.listenerType, b);
            root.addPhaseListener((PhaseListener)pl);
        }
    }

    private static final class LazyPhaseListener
    implements PhaseListener,
    Serializable {
        private static final long serialVersionUID = -6496143057319213401L;
        private final String type;
        private final ValueExpression binding;

        public LazyPhaseListener(String type, ValueExpression binding) {
            this.type = type;
            this.binding = binding;
        }

        private PhaseListener getInstance() {
            PhaseListener instance = null;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null) {
                return null;
            }
            if (this.binding != null) {
                instance = (PhaseListener)this.binding.getValue(facesContext.getELContext());
            }
            if (instance == null && this.type != null) {
                try {
                    instance = (PhaseListener)ClassUtils.forName((String)this.type).newInstance();
                }
                catch (Exception e) {
                    throw new AbortProcessingException("Couldn't Lazily instantiate PhaseListener", (Throwable)e);
                }
                if (this.binding != null) {
                    this.binding.setValue(facesContext.getELContext(), (Object)instance);
                }
            }
            return instance;
        }

        public void afterPhase(PhaseEvent event) {
            PhaseListener pl = this.getInstance();
            if (pl != null) {
                pl.afterPhase(event);
            }
        }

        public void beforePhase(PhaseEvent event) {
            PhaseListener pl = this.getInstance();
            if (pl != null) {
                pl.beforePhase(event);
            }
        }

        public PhaseId getPhaseId() {
            PhaseListener pl = this.getInstance();
            return pl != null ? pl.getPhaseId() : PhaseId.ANY_PHASE;
        }
    }
}

