/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.integration.file.DefaultDirectoryScanner;
import org.springframework.integration.file.filters.AbstractFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.util.Assert;

public class RecursiveDirectoryScanner
extends DefaultDirectoryScanner {
    private int maxDepth = Integer.MAX_VALUE;
    private FileVisitOption[] fileVisitOptions = new FileVisitOption[0];

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public void setFileVisitOptions(FileVisitOption ... fileVisitOptions) {
        Assert.notNull((Object)fileVisitOptions, (String)"'fileVisitOptions' must not be null");
        this.fileVisitOptions = Arrays.copyOf(fileVisitOptions, fileVisitOptions.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<File> listFiles(File directory) throws IllegalArgumentException {
        FileListFilter<File> filter = this.getFilter();
        boolean supportAcceptFilter = filter instanceof AbstractFileListFilter;
        try (Stream<Path> pathStream = Files.walk(directory.toPath(), this.maxDepth, this.fileVisitOptions);){
            Stream<File> fileStream = pathStream.skip(1L).map(Path::toFile).filter(file -> !supportAcceptFilter || filter.accept((File)file));
            if (supportAcceptFilter) {
                List<File> list2 = fileStream.collect(Collectors.toList());
                return list2;
            }
            List<File> list = filter.filterFiles((File[])((File[])fileStream.toArray(File[]::new)));
            return list;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

