/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.recursive.comparison.ComparatorForPatterns;
import org.assertj.core.api.recursive.comparison.FieldHolder;
import org.assertj.core.data.MapEntry;

public class FieldComparators
extends FieldHolder<Comparator<?>> {
    protected final LinkedList<ComparatorForPatterns> comparatorByPatterns = new LinkedList();

    public void registerComparator(String fieldLocation, Comparator<?> comparator) {
        super.put(fieldLocation, comparator);
    }

    public void registerComparatorForFieldsMatchingRegexes(String[] regexes, Comparator<?> comparator) {
        List<Pattern> patterns = Stream.of(regexes).map(Pattern::compile).collect(Collectors.toList());
        this.comparatorByPatterns.addFirst(new ComparatorForPatterns(patterns, comparator));
    }

    public boolean hasComparatorForField(String fieldLocation) {
        boolean hasComparatorForExactFieldLocation = super.hasEntity(fieldLocation);
        if (hasComparatorForExactFieldLocation) {
            return true;
        }
        return this.comparatorByPatterns.stream().anyMatch(comparatorForPatterns -> comparatorForPatterns.hasComparatorForField(fieldLocation));
    }

    public Comparator<?> getComparatorForField(String fieldLocation) {
        Comparator exactFieldLocationComparator = (Comparator)super.get(fieldLocation);
        if (exactFieldLocationComparator != null) {
            return exactFieldLocationComparator;
        }
        return this.comparatorByPatterns.stream().map(comparatorForPatterns -> comparatorForPatterns.getComparatorForField(fieldLocation)).filter(comparator -> comparator != null).findFirst().orElse(null);
    }

    public Stream<Map.Entry<String, Comparator<?>>> comparatorByFields() {
        return super.entryByField();
    }

    public Stream<Map.Entry<List<Pattern>, Comparator<?>>> comparatorByRegexFields() {
        return this.comparatorByPatterns.stream().map(comparatorForPatterns -> MapEntry.entry(comparatorForPatterns.fieldPatterns, comparatorForPatterns.comparator));
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.comparatorByPatterns.isEmpty();
    }

    public boolean hasFieldComparators() {
        return !super.isEmpty();
    }

    public boolean hasRegexFieldComparators() {
        return !this.comparatorByPatterns.isEmpty();
    }
}

