/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.GroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.WildcardUnmarshaller;

public class ComplexContentRestrictionUnmarshaller
extends ComponentReader {
    private ComponentReader unmarshaller;
    private int depth = 0;
    private ComplexType _complexType = null;
    private Schema _schema = null;
    private boolean foundAnnotation = false;
    private boolean foundAttribute = false;
    private boolean foundAttributeGroup = false;
    private boolean foundModelGroup = false;

    public ComplexContentRestrictionUnmarshaller(ComplexType complexType, AttributeSet atts, Resolver resolver) throws XMLException {
        this.setResolver(resolver);
        this._complexType = complexType;
        this._schema = complexType.getSchema();
        this._complexType.setDerivationMethod("restriction");
        this._complexType.setRestriction(true);
        String base = atts.getValue("base");
        if (base != null && base.length() > 0) {
            XMLType baseType = this._schema.getType(base);
            if (baseType == null) {
                this._complexType.setBase(base);
            } else {
                if (baseType.isSimpleType()) {
                    String err = "complexType: " + this._complexType.getName() != null ? this._complexType.getName() : "\n";
                    err = err + "A complex type cannot be a restriction of a simpleType.";
                    throw new IllegalStateException(err);
                }
                if (!baseType.isAnyType()) {
                    // empty if block
                }
            }
            this._complexType.setBase(base);
            this._complexType.setBaseType(baseType);
        }
    }

    public String elementName() {
        return "restriction";
    }

    public Object getObject() {
        return null;
    }

    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this.depth;
            return;
        }
        if (name.equals("annotation")) {
            if (this.foundModelGroup || this.foundAttribute || this.foundAttributeGroup) {
                this.error("An annotation must appear as the first child of 'restriction' elements.");
            }
            if (this.foundAnnotation) {
                this.error("Only one (1) annotation may appear as a child of 'restriction' elements.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(atts);
        } else if (SchemaNames.isGroupName(name)) {
            if (this.foundAttribute || this.foundAttributeGroup) {
                this.error("'" + name + "' must appear before any attribute " + "definitions when a child of 'restriction'.");
            }
            if (this.foundModelGroup) {
                this.error("'" + name + "' cannot appear as a child of 'restriction' " + "if another 'all', 'sequence', 'choice' or " + "'group' also exists.");
            }
            this.foundModelGroup = true;
            this.unmarshaller = new GroupUnmarshaller(this._schema, name, atts, this.getResolver());
        } else if ("attribute".equals(name)) {
            this.foundAttribute = true;
            this.unmarshaller = new AttributeUnmarshaller(this._schema, atts, this.getResolver());
        } else if ("attributeGroup".equals(name)) {
            if (atts.getValue("ref") == null) {
                this.error("A 'complexType' may contain referring attributeGroups, but not defining ones.");
            }
            this.foundAttributeGroup = true;
            this.unmarshaller = new AttributeGroupUnmarshaller(this._schema, atts);
        } else if ("anyAttribute".equals(name)) {
            this.unmarshaller = new WildcardUnmarshaller(this._complexType, this._schema, name, atts, this.getResolver());
        } else {
            this.illegalElement(name);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    public void endElement(String name, String namespace) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(name, namespace);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("annotation".equals(name)) {
            Annotation ann = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._complexType.addAnnotation(ann);
        } else if ("anyAttribute".equals(name)) {
            Wildcard wildcard = ((WildcardUnmarshaller)this.unmarshaller).getWildcard();
            try {
                this._complexType.setAnyAttribute(wildcard);
            }
            catch (SchemaException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        } else if ("attribute".equals(name)) {
            AttributeDecl attrDecl = ((AttributeUnmarshaller)this.unmarshaller).getAttribute();
            this._complexType.addAttributeDecl(attrDecl);
        } else if ("attributeGroup".equals(name)) {
            AttributeGroupReference attrGroupRef = (AttributeGroupReference)this.unmarshaller.getObject();
            this._complexType.addAttributeGroupReference(attrGroupRef);
        } else if (SchemaNames.isGroupName(name)) {
            Group group = ((GroupUnmarshaller)this.unmarshaller).getGroup();
            this._complexType.addGroup(group);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(ch, start, length);
        }
    }
}

