/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.StructurePseudoDS;
import ucar.nc2.dataset.VariableDS;

public class StructurePseudo2Dim
extends StructurePseudoDS {
    private static Logger log = LoggerFactory.getLogger(StructurePseudo2Dim.class);
    private List<Variable> orgVariables = new ArrayList<Variable>();
    private static final boolean debugRecord = false;

    public StructurePseudo2Dim(NetcdfDataset ncfile, Group group, String shortName, List<String> varNames, Dimension outer, Dimension inner) {
        super(ncfile, group, shortName);
        this.setDataType(DataType.STRUCTURE);
        ArrayList<Dimension> dims = new ArrayList<Dimension>(2);
        dims.add(outer);
        dims.add(inner);
        this.setDimensions(dims);
        if (group == null) {
            group = ncfile.getRootGroup();
        }
        if (varNames == null) {
            List<Variable> vars = group.getVariables();
            varNames = new ArrayList<String>(vars.size());
            for (Variable orgV : vars) {
                if (orgV.getRank() < 2 || !outer.equals(orgV.getDimension(0)) || !inner.equals(orgV.getDimension(1))) continue;
                varNames.add(orgV.getShortName());
            }
        }
        for (String name : varNames) {
            Variable orgV;
            orgV = group.findVariable(name);
            if (orgV == null) {
                log.warn("StructurePseudo2Dim cannot find variable " + name);
                continue;
            }
            if (!outer.equals(orgV.getDimension(0))) {
                throw new IllegalArgumentException("Variable " + orgV.getNameAndDimensions() + " must have outermost dimension=" + outer);
            }
            if (!inner.equals(orgV.getDimension(1))) {
                throw new IllegalArgumentException("Variable " + orgV.getNameAndDimensions() + " must have 2nd dimension=" + inner);
            }
            VariableDS memberV = new VariableDS(ncfile, group, this, orgV.getShortName(), orgV.getDataType(), null, orgV.getUnitsString(), orgV.getDescription());
            memberV.setDataType(orgV.getDataType());
            memberV.setSPobject(orgV.getSPobject());
            memberV.addAll(orgV.getAttributes());
            ArrayList<Dimension> dimList = new ArrayList<Dimension>(orgV.getDimensions());
            memberV.setDimensions(dimList.subList(2, dimList.size()));
            memberV.enhance(enhanceScaleMissing);
            this.addMemberVariable(memberV);
            this.orgVariables.add(orgV);
        }
        this.calcElementSize();
    }

    @Override
    public Structure select(List<String> memberNames) {
        StructurePseudo2Dim result = new StructurePseudo2Dim((NetcdfDataset)this.ncfile, this.getParentGroup(), this.getShortName(), memberNames, this.getDimension(0), this.getDimension(1));
        result.isSubset = true;
        return result;
    }

    @Override
    protected Array _read(Section section) throws IOException, InvalidRangeException {
        if (null == section) {
            return this._read();
        }
        String err = section.checkInRange(this.getShape());
        if (err != null) {
            throw new InvalidRangeException(err);
        }
        Range outerRange = section.getRange(0);
        Range innerRange = section.getRange(1);
        StructureMembers smembers = this.makeStructureMembers();
        ArrayStructureMA asma = new ArrayStructureMA(smembers, section.getShape());
        for (Variable v : this.orgVariables) {
            ArrayList<Range> vsection = new ArrayList<Range>(v.getRanges());
            vsection.set(0, outerRange);
            vsection.set(1, innerRange);
            Array data = v.read(vsection);
            StructureMembers.Member m = smembers.findMember(v.getShortName());
            m.setDataArray(data);
        }
        return asma;
    }
}

