/*
 * Decompiled with CFR 0.152.
 */
package org.itadaki.bzip2;

import java.io.IOException;
import org.itadaki.bzip2.BZip2BitInputStream;
import org.itadaki.bzip2.BZip2Exception;

public class BZip2HuffmanStageDecoder {
    private final BZip2BitInputStream bitInputStream;
    private final byte[] selectors;
    private final int[] minimumLengths = new int[6];
    private final int[][] codeBases = new int[6][25];
    private final int[][] codeLimits = new int[6][24];
    private final int[][] codeSymbols = new int[6][258];
    private int currentTable;
    private int groupIndex = -1;
    private int groupPosition = -1;

    private void createHuffmanDecodingTables(int alphabetSize, byte[][] tableCodeLengths) {
        for (int table = 0; table < tableCodeLengths.length; ++table) {
            int i;
            int[] tableBases = this.codeBases[table];
            int[] tableLimits = this.codeLimits[table];
            int[] tableSymbols = this.codeSymbols[table];
            byte[] codeLengths = tableCodeLengths[table];
            int minimumLength = 23;
            int maximumLength = 0;
            for (i = 0; i < alphabetSize; ++i) {
                maximumLength = Math.max(codeLengths[i], maximumLength);
                minimumLength = Math.min(codeLengths[i], minimumLength);
            }
            this.minimumLengths[table] = minimumLength;
            for (i = 0; i < alphabetSize; ++i) {
                int n = codeLengths[i] + 1;
                tableBases[n] = tableBases[n] + 1;
            }
            for (i = 1; i < 25; ++i) {
                int n = i;
                tableBases[n] = tableBases[n] + tableBases[i - 1];
            }
            int code = 0;
            for (int i2 = minimumLength; i2 <= maximumLength; ++i2) {
                int base = code;
                tableBases[i2] = base - tableBases[i2];
                tableLimits[i2] = (code += tableBases[i2 + 1] - tableBases[i2]) - 1;
                code <<= 1;
            }
            int codeIndex = 0;
            for (int bitLength = minimumLength; bitLength <= maximumLength; ++bitLength) {
                for (int symbol = 0; symbol < alphabetSize; ++symbol) {
                    if (codeLengths[symbol] != bitLength) continue;
                    tableSymbols[codeIndex++] = symbol;
                }
            }
        }
    }

    public int nextSymbol() throws IOException {
        int codeLength;
        BZip2BitInputStream bitInputStream = this.bitInputStream;
        if (++this.groupPosition % 50 == 0) {
            ++this.groupIndex;
            if (this.groupIndex == this.selectors.length) {
                throw new BZip2Exception("Error decoding BZip2 block");
            }
            this.currentTable = this.selectors[this.groupIndex] & 0xFF;
        }
        int currentTable = this.currentTable;
        int[] tableLimits = this.codeLimits[currentTable];
        int codeBits = bitInputStream.readBits(codeLength);
        for (codeLength = this.minimumLengths[currentTable]; codeLength <= 23; ++codeLength) {
            if (codeBits <= tableLimits[codeLength]) {
                return this.codeSymbols[currentTable][codeBits - this.codeBases[currentTable][codeLength]];
            }
            codeBits = codeBits << 1 | bitInputStream.readBits(1);
        }
        throw new BZip2Exception("Error decoding BZip2 block");
    }

    public BZip2HuffmanStageDecoder(BZip2BitInputStream bitInputStream, int alphabetSize, byte[][] tableCodeLengths, byte[] selectors) {
        this.bitInputStream = bitInputStream;
        this.selectors = selectors;
        this.currentTable = this.selectors[0];
        this.createHuffmanDecodingTables(alphabetSize, tableCodeLengths);
    }
}

