/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response.schema;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.request.schema.AnalyzerDefinition;
import org.apache.solr.client.solrj.request.schema.FieldTypeDefinition;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.client.solrj.response.schema.FieldTypeRepresentation;
import org.apache.solr.client.solrj.response.schema.SchemaRepresentation;
import org.apache.solr.common.util.NamedList;

public class SchemaResponse
extends SolrResponseBase {
    private SchemaRepresentation schemaRepresentation;

    private static <T> Map<String, T> extractAttributeMap(NamedList<T> namedList) {
        if (namedList == null) {
            return null;
        }
        LinkedHashMap<String, T> result = new LinkedHashMap<String, T>();
        for (int i = 0; i < namedList.size(); ++i) {
            T val = namedList.getVal(i);
            String name = namedList.getName(i);
            if (val instanceof NamedList || val instanceof List) continue;
            result.put(name, val);
        }
        return result;
    }

    private static AnalyzerDefinition createAnalyzerDefinition(NamedList<Object> analyzerNamedList) {
        NamedList tokenizerNamedList;
        AnalyzerDefinition analyzerDefinition = new AnalyzerDefinition();
        Map<String, Object> analyzerAttributes = SchemaResponse.extractAttributeMap(analyzerNamedList);
        analyzerDefinition.setAttributes(analyzerAttributes);
        List charFiltersList = (List)analyzerNamedList.get("charFilters");
        if (charFiltersList != null) {
            LinkedList<Map<String, Object>> charFiltersAttributesList = new LinkedList<Map<String, Object>>();
            for (NamedList charFilterNamedList : charFiltersList) {
                Map charFilterAttributes = SchemaResponse.extractAttributeMap(charFilterNamedList);
                charFiltersAttributesList.add(charFilterAttributes);
            }
            analyzerDefinition.setCharFilters(charFiltersAttributesList);
        }
        if ((tokenizerNamedList = (NamedList)analyzerNamedList.get("tokenizer")) != null) {
            Map<String, Object> tokenizerAttributes = SchemaResponse.extractAttributeMap(tokenizerNamedList);
            analyzerDefinition.setTokenizer(tokenizerAttributes);
        }
        List filtersList = (List)analyzerNamedList.get("filters");
        LinkedList<Map<String, Object>> filtersAttributesList = new LinkedList<Map<String, Object>>();
        if (filtersList != null) {
            for (NamedList filterNamedList : filtersList) {
                Map filterAttributes = SchemaResponse.extractAttributeMap(filterNamedList);
                filtersAttributesList.add(filterAttributes);
            }
            analyzerDefinition.setFilters(filtersAttributesList);
        }
        return analyzerDefinition;
    }

    private static FieldTypeDefinition createFieldTypeDefinition(NamedList<Object> fieldTypeNamedList) {
        FieldTypeDefinition fieldTypeDefinition = new FieldTypeDefinition();
        SchemaResponse.fillFieldTypeDefinition(fieldTypeDefinition, fieldTypeNamedList);
        return fieldTypeDefinition;
    }

    private static FieldTypeRepresentation createFieldTypeRepresentation(NamedList<Object> fieldTypeNamedList) {
        List dynamicFields;
        FieldTypeRepresentation fieldTypeRepresentation = new FieldTypeRepresentation();
        SchemaResponse.fillFieldTypeDefinition(fieldTypeRepresentation, fieldTypeNamedList);
        List fields = (List)fieldTypeNamedList.get("fields");
        if (fields != null) {
            fieldTypeRepresentation.setFields(fields);
        }
        if ((dynamicFields = (List)fieldTypeNamedList.get("dynamicFields")) != null) {
            fieldTypeRepresentation.setDynamicFields(dynamicFields);
        }
        return fieldTypeRepresentation;
    }

    private static void fillFieldTypeDefinition(FieldTypeDefinition fieldTypeDefinition, NamedList<Object> fieldTypeNamedList) {
        NamedList similarityNamedList;
        NamedList multiTermAnalyzerNamedList;
        NamedList queryAnalyzerNamedList;
        NamedList indexAnalyzerNamedList;
        Map<String, Object> fieldTypeAttributes = SchemaResponse.extractAttributeMap(fieldTypeNamedList);
        fieldTypeDefinition.setAttributes(fieldTypeAttributes);
        NamedList analyzerNamedList = (NamedList)fieldTypeNamedList.get("analyzer");
        if (analyzerNamedList != null) {
            AnalyzerDefinition analyzerDefinition = SchemaResponse.createAnalyzerDefinition(analyzerNamedList);
            fieldTypeDefinition.setAnalyzer(analyzerDefinition);
        }
        if ((indexAnalyzerNamedList = (NamedList)fieldTypeNamedList.get("indexAnalyzer")) != null) {
            AnalyzerDefinition indexAnalyzerDefinition = SchemaResponse.createAnalyzerDefinition(indexAnalyzerNamedList);
            fieldTypeDefinition.setIndexAnalyzer(indexAnalyzerDefinition);
        }
        if ((queryAnalyzerNamedList = (NamedList)fieldTypeNamedList.get("queryAnalyzer")) != null) {
            AnalyzerDefinition queryAnalyzerDefinition = SchemaResponse.createAnalyzerDefinition(queryAnalyzerNamedList);
            fieldTypeDefinition.setQueryAnalyzer(queryAnalyzerDefinition);
        }
        if ((multiTermAnalyzerNamedList = (NamedList)fieldTypeNamedList.get("multiTermAnalyzer")) != null) {
            AnalyzerDefinition multiTermAnalyzerDefinition = SchemaResponse.createAnalyzerDefinition(multiTermAnalyzerNamedList);
            fieldTypeDefinition.setMultiTermAnalyzer(multiTermAnalyzerDefinition);
        }
        if ((similarityNamedList = (NamedList)fieldTypeNamedList.get("similarity")) != null) {
            Map<String, Object> similarityAttributes = SchemaResponse.extractAttributeMap(similarityNamedList);
            fieldTypeDefinition.setSimilarity(similarityAttributes);
        }
    }

    private static SchemaRepresentation createSchemaConfiguration(Map schemaObj) {
        SchemaRepresentation schemaRepresentation = new SchemaRepresentation();
        schemaRepresentation.setName(SchemaResponse.getSchemaName(schemaObj));
        schemaRepresentation.setVersion(SchemaResponse.getSchemaVersion(schemaObj).floatValue());
        schemaRepresentation.setUniqueKey(SchemaResponse.getSchemaUniqueKey(schemaObj));
        schemaRepresentation.setSimilarity(SchemaResponse.getSimilarity(schemaObj));
        schemaRepresentation.setFields(SchemaResponse.getFields(schemaObj));
        schemaRepresentation.setDynamicFields(SchemaResponse.getDynamicFields(schemaObj));
        schemaRepresentation.setFieldTypes(SchemaResponse.getFieldTypeDefinitions(schemaObj));
        schemaRepresentation.setCopyFields(SchemaResponse.getCopyFields(schemaObj));
        return schemaRepresentation;
    }

    private static String getSchemaName(Map schemaNamedList) {
        return (String)schemaNamedList.get("name");
    }

    private static Float getSchemaVersion(Map schemaNamedList) {
        return (Float)schemaNamedList.get("version");
    }

    private static String getSchemaUniqueKey(Map schemaNamedList) {
        return (String)schemaNamedList.get("uniqueKey");
    }

    private static Map<String, Object> getSimilarity(Map schemaNamedList) {
        NamedList similarityNamedList = (NamedList)schemaNamedList.get("similarity");
        Map similarity = null;
        if (similarityNamedList != null) {
            similarity = SchemaResponse.extractAttributeMap(similarityNamedList);
        }
        return similarity;
    }

    private static List<Map<String, Object>> getFields(Map schemaNamedList) {
        LinkedList<Map<String, Object>> fieldsAttributes = new LinkedList<Map<String, Object>>();
        List fieldsResponse = (List)schemaNamedList.get("fields");
        for (NamedList fieldNamedList : fieldsResponse) {
            LinkedHashMap fieldAttributes = new LinkedHashMap();
            fieldAttributes.putAll(SchemaResponse.extractAttributeMap(fieldNamedList));
            fieldsAttributes.add(fieldAttributes);
        }
        return fieldsAttributes;
    }

    private static List<Map<String, Object>> getDynamicFields(Map schemaNamedList) {
        LinkedList<Map<String, Object>> dynamicFieldsAttributes = new LinkedList<Map<String, Object>>();
        List dynamicFieldsResponse = (List)schemaNamedList.get("dynamicFields");
        for (NamedList fieldNamedList : dynamicFieldsResponse) {
            LinkedHashMap dynamicFieldAttributes = new LinkedHashMap();
            dynamicFieldAttributes.putAll(SchemaResponse.extractAttributeMap(fieldNamedList));
            dynamicFieldsAttributes.add(dynamicFieldAttributes);
        }
        return dynamicFieldsAttributes;
    }

    private static List<Map<String, Object>> getCopyFields(Map schemaNamedList) {
        LinkedList<Map<String, Object>> copyFieldsAttributes = new LinkedList<Map<String, Object>>();
        List copyFieldsResponse = (List)schemaNamedList.get("copyFields");
        for (NamedList copyFieldNamedList : copyFieldsResponse) {
            LinkedHashMap copyFieldAttributes = new LinkedHashMap();
            copyFieldAttributes.putAll(SchemaResponse.extractAttributeMap(copyFieldNamedList));
            copyFieldsAttributes.add(copyFieldAttributes);
        }
        return copyFieldsAttributes;
    }

    private static List<FieldTypeDefinition> getFieldTypeDefinitions(Map schemaNamedList) {
        LinkedList<FieldTypeDefinition> fieldTypeDefinitions = new LinkedList<FieldTypeDefinition>();
        List fieldsResponse = (List)schemaNamedList.get("fieldTypes");
        for (NamedList fieldNamedList : fieldsResponse) {
            FieldTypeDefinition fieldTypeDefinition = SchemaResponse.createFieldTypeDefinition(fieldNamedList);
            fieldTypeDefinitions.add(fieldTypeDefinition);
        }
        return fieldTypeDefinitions;
    }

    private static List<FieldTypeRepresentation> getFieldTypeRepresentations(Map schemaNamedList) {
        LinkedList<FieldTypeRepresentation> fieldTypeRepresentations = new LinkedList<FieldTypeRepresentation>();
        List fieldsResponse = (List)schemaNamedList.get("fieldTypes");
        for (NamedList fieldNamedList : fieldsResponse) {
            FieldTypeRepresentation fieldTypeRepresentation = SchemaResponse.createFieldTypeRepresentation(fieldNamedList);
            fieldTypeRepresentations.add(fieldTypeRepresentation);
        }
        return fieldTypeRepresentations;
    }

    @Override
    public void setResponse(NamedList<Object> response) {
        super.setResponse(response);
        Map schemaObj = (Map)response.get("schema");
        this.schemaRepresentation = SchemaResponse.createSchemaConfiguration(schemaObj);
    }

    public SchemaRepresentation getSchemaRepresentation() {
        return this.schemaRepresentation;
    }

    public static class UpdateResponse
    extends SolrResponseBase {
        @Override
        public void setResponse(NamedList<Object> response) {
            super.setResponse(response);
        }
    }

    public static class FieldTypesResponse
    extends SolrResponseBase {
        List<FieldTypeRepresentation> fieldTypes;

        @Override
        public void setResponse(NamedList<Object> response) {
            super.setResponse(response);
            this.fieldTypes = SchemaResponse.getFieldTypeRepresentations(response.asShallowMap());
        }

        public List<FieldTypeRepresentation> getFieldTypes() {
            return this.fieldTypes;
        }
    }

    public static class FieldTypeResponse
    extends SolrResponseBase {
        private FieldTypeRepresentation fieldType;

        @Override
        public void setResponse(NamedList<Object> response) {
            super.setResponse(response);
            NamedList fieldTypeNamedList = (NamedList)response.get("fieldType");
            this.fieldType = SchemaResponse.createFieldTypeRepresentation(fieldTypeNamedList);
        }

        public FieldTypeRepresentation getFieldType() {
            return this.fieldType;
        }
    }

    public static class CopyFieldsResponse
    extends SolrResponseBase {
        List<Map<String, Object>> copyFields;

        @Override
        public void setResponse(NamedList<Object> response) {
            super.setResponse(response);
            this.copyFields = SchemaResponse.getCopyFields(response.asShallowMap());
        }

        public List<Map<String, Object>> getCopyFields() {
            return this.copyFields;
        }
    }

    public static class GlobalSimilarityResponse
    extends SolrResponseBase {
        Map<String, Object> similarity;

        @Override
        public void setResponse(NamedList<Object> response) {
            super.setResponse(response);
            this.similarity = SchemaResponse.getSimilarity(response.asShallowMap());
        }

        public Map<String, Object> getSimilarity() {
            return this.similarity;
        }
    }

    public static class UniqueKeyResponse
    extends SolrResponseBase {
        private String uniqueKey;

        @Override
        public void setResponse(NamedList<Object> response) {
            super.setResponse(response);
            this.uniqueKey = SchemaResponse.getSchemaUniqueKey(response.asShallowMap());
        }

        public String getUniqueKey() {
            return this.uniqueKey;
        }
    }

    public static class DynamicFieldsResponse
    extends SolrResponseBase {
        List<Map<String, Object>> dynamicFields;

        @Override
        public void setResponse(NamedList<Object> response) {
            super.setResponse(response);
            this.dynamicFields = SchemaResponse.getDynamicFields(response.asMap(3));
        }

        public List<Map<String, Object>> getDynamicFields() {
            return this.dynamicFields;
        }
    }

    public static class DynamicFieldResponse
    extends SolrResponseBase {
        Map<String, Object> dynamicField = new LinkedHashMap<String, Object>();

        @Override
        public void setResponse(NamedList<Object> response) {
            super.setResponse(response);
            NamedList dynamicFieldResponse = (NamedList)response.get("dynamicField");
            this.dynamicField.putAll(SchemaResponse.extractAttributeMap(dynamicFieldResponse));
        }

        public Map<String, Object> getDynamicField() {
            return this.dynamicField;
        }
    }

    public static class FieldsResponse
    extends SolrResponseBase {
        List<Map<String, Object>> fields;

        @Override
        public void setResponse(NamedList<Object> response) {
            super.setResponse(response);
            this.fields = SchemaResponse.getFields(response.asShallowMap());
        }

        public List<Map<String, Object>> getFields() {
            return this.fields;
        }
    }

    public static class FieldResponse
    extends SolrResponseBase {
        Map<String, Object> field = new LinkedHashMap<String, Object>();

        @Override
        public void setResponse(NamedList<Object> response) {
            super.setResponse(response);
            NamedList fieldResponse = (NamedList)response.get("field");
            this.field.putAll(SchemaResponse.extractAttributeMap(fieldResponse));
        }

        public Map<String, Object> getField() {
            return this.field;
        }
    }

    public static class SchemaVersionResponse
    extends SolrResponseBase {
        private float schemaVersion;

        @Override
        public void setResponse(NamedList<Object> response) {
            super.setResponse(response);
            this.schemaVersion = SchemaResponse.getSchemaVersion(response.asShallowMap()).floatValue();
        }

        public float getSchemaVersion() {
            return this.schemaVersion;
        }
    }

    public static class SchemaNameResponse
    extends SolrResponseBase {
        private String schemaName;

        @Override
        public void setResponse(NamedList<Object> response) {
            super.setResponse(response);
            this.schemaName = SchemaResponse.getSchemaName(response.asShallowMap());
        }

        public String getSchemaName() {
            return this.schemaName;
        }
    }
}

