/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.internal.hppc.IntHashSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphBuilder;
import org.apache.lucene.util.hnsw.InitializedHnswGraphBuilder;
import org.apache.lucene.util.hnsw.OnHeapHnswGraph;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.UpdateGraphsUtils;

public final class MergingHnswGraphBuilder
extends HnswGraphBuilder {
    private final HnswGraph[] graphs;
    private final int[][] ordMaps;
    private final BitSet initializedNodes;

    private MergingHnswGraphBuilder(RandomVectorScorerSupplier scorerSupplier, int M, int beamWidth, long seed, OnHeapHnswGraph initializedGraph, HnswGraph[] graphs, int[][] ordMaps, BitSet initializedNodes) throws IOException {
        super(scorerSupplier, M, beamWidth, seed, initializedGraph);
        this.graphs = graphs;
        this.ordMaps = ordMaps;
        this.initializedNodes = initializedNodes;
    }

    public static MergingHnswGraphBuilder fromGraphs(RandomVectorScorerSupplier scorerSupplier, int M, int beamWidth, long seed, HnswGraph[] graphs, int[][] ordMaps, int totalNumberOfVectors, BitSet initializedNodes) throws IOException {
        OnHeapHnswGraph graph = InitializedHnswGraphBuilder.initGraph(graphs[0], ordMaps[0], totalNumberOfVectors, beamWidth, scorerSupplier);
        return new MergingHnswGraphBuilder(scorerSupplier, M, beamWidth, seed, graph, graphs, ordMaps, initializedNodes);
    }

    @Override
    public OnHeapHnswGraph build(int maxOrd) throws IOException {
        if (this.frozen) {
            throw new IllegalStateException("This HnswGraphBuilder is frozen and cannot be updated");
        }
        if (this.infoStream.isEnabled("HNSW")) {
            Object graphSizes = "";
            for (HnswGraph g : this.graphs) {
                graphSizes = (String)graphSizes + g.size() + " ";
            }
            this.infoStream.message("HNSW", "build graph from merging " + this.graphs.length + " graphs of " + maxOrd + " vectors, graph sizes:" + (String)graphSizes);
        }
        for (int i = 1; i < this.graphs.length; ++i) {
            this.updateGraph(this.graphs[i], this.ordMaps[i]);
        }
        if (this.initializedNodes != null) {
            for (int node = 0; node < maxOrd; ++node) {
                if (this.initializedNodes.get(node)) continue;
                this.addGraphNode(node);
            }
        }
        return this.getCompletedGraph();
    }

    private void updateGraph(HnswGraph gS, int[] ordMapS) throws IOException {
        int size = gS.size();
        IntHashSet j = UpdateGraphsUtils.computeJoinSet(gS);
        int[] nodes = j.toArray();
        Arrays.sort(nodes);
        for (int node : nodes) {
            this.addGraphNode(ordMapS[node]);
        }
        for (int u = 0; u < size; ++u) {
            if (j.contains(u)) continue;
            IntHashSet eps = new IntHashSet();
            gS.seek(0, u);
            int v = gS.nextNeighbor();
            while (v != Integer.MAX_VALUE) {
                if (v < u || j.contains(v)) {
                    int friendOrd;
                    int newv = ordMapS[v];
                    eps.add(newv);
                    this.hnsw.seek(0, newv);
                    while ((friendOrd = this.hnsw.nextNeighbor()) != Integer.MAX_VALUE) {
                        eps.add(friendOrd);
                    }
                }
                v = gS.nextNeighbor();
            }
            this.addGraphNode(ordMapS[u], eps);
        }
    }
}

