/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SplittableRandom;
import org.apache.lucene.internal.hppc.IntArrayList;
import org.apache.lucene.internal.hppc.IntCursor;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphBuilder;
import org.apache.lucene.util.hnsw.NeighborArray;
import org.apache.lucene.util.hnsw.OnHeapHnswGraph;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.UpdateableRandomVectorScorer;

public final class InitializedHnswGraphBuilder
extends HnswGraphBuilder {
    private final BitSet initializedNodes;
    private IntArrayList[] levelToNodes;
    private final double DISCONNECTED_NODE_FACTOR = 0.85;
    private boolean hasDeletes = false;

    public static InitializedHnswGraphBuilder fromGraph(RandomVectorScorerSupplier scorerSupplier, int beamWidth, long seed, HnswGraph initializerGraph, int[] newOrdMap, BitSet initializedNodes, int totalNumberOfVectors) throws IOException {
        InitializedHnswGraphBuilder builder = new InitializedHnswGraphBuilder(scorerSupplier, beamWidth, seed, new OnHeapHnswGraph(initializerGraph.maxConn(), totalNumberOfVectors), initializedNodes);
        builder.initializeFromGraph(initializerGraph, newOrdMap);
        return builder;
    }

    public static OnHeapHnswGraph initGraph(HnswGraph initializerGraph, int[] newOrdMap, int totalNumberOfVectors, int beamWidth, RandomVectorScorerSupplier scorerSupplier) throws IOException {
        InitializedHnswGraphBuilder builder = InitializedHnswGraphBuilder.fromGraph(scorerSupplier, beamWidth, randSeed, initializerGraph, newOrdMap, null, totalNumberOfVectors);
        return builder.getGraph();
    }

    private InitializedHnswGraphBuilder(RandomVectorScorerSupplier scorerSupplier, int beamWidth, long seed, OnHeapHnswGraph initializedGraph, BitSet initializedNodes) throws IOException {
        super(scorerSupplier, beamWidth, seed, initializedGraph);
        this.initializedNodes = initializedNodes;
    }

    private void initializeFromGraph(HnswGraph initializerGraph, int[] newOrdMap) throws IOException {
        this.hasDeletes = false;
        Map<Integer, List<Integer>> disconnectedNodesByLevel = this.copyGraphStructure(initializerGraph, newOrdMap);
        if (this.hasDeletes) {
            this.repairDisconnectedNodes(disconnectedNodesByLevel, initializerGraph.numLevels());
            this.rebalanceGraph();
        }
    }

    private Map<Integer, List<Integer>> copyGraphStructure(HnswGraph initializerGraph, int[] newOrdMap) throws IOException {
        int numLevels = initializerGraph.numLevels();
        this.levelToNodes = new IntArrayList[numLevels];
        HashMap<Integer, List<Integer>> disconnectedNodesByLevel = new HashMap<Integer, List<Integer>>(numLevels);
        for (int level = numLevels - 1; level >= 0; --level) {
            this.levelToNodes[level] = new IntArrayList();
            ArrayList<Integer> disconnectedNodes = new ArrayList<Integer>();
            HnswGraph.NodesIterator it = initializerGraph.getNodesOnLevel(level);
            while (it.hasNext()) {
                int oldOrd = it.nextInt();
                int newOrd = newOrdMap[oldOrd];
                if (newOrd == -1) {
                    this.hasDeletes = true;
                    continue;
                }
                this.hnsw.addNode(level, newOrd);
                this.levelToNodes[level].add(newOrd);
                this.hnsw.trySetNewEntryNode(newOrd, level);
                this.scorer.setScoringOrdinal(newOrd);
                NeighborArray newNeighbors = this.hnsw.getNeighbors(level, newOrd);
                initializerGraph.seek(level, oldOrd);
                int oldNeighbourCount = 0;
                int oldNeighbor = initializerGraph.nextNeighbor();
                while (oldNeighbor != Integer.MAX_VALUE) {
                    ++oldNeighbourCount;
                    int newNeighbor = newOrdMap[oldNeighbor];
                    if (newNeighbor != -1) {
                        newNeighbors.addOutOfOrder(newNeighbor, Float.NaN);
                    }
                    oldNeighbor = initializerGraph.nextNeighbor();
                }
                if (!((double)newNeighbors.size() < (double)oldNeighbourCount * 0.85)) continue;
                disconnectedNodes.add(newOrd);
            }
            disconnectedNodesByLevel.put(level, disconnectedNodes);
        }
        return disconnectedNodesByLevel;
    }

    private void repairDisconnectedNodes(Map<Integer, List<Integer>> disconnectedNodesByLevel, int numLevels) throws IOException {
        for (int level = numLevels - 1; level >= 0; --level) {
            this.fixDisconnectedNodes(disconnectedNodesByLevel.get(level), level, this.scorer);
        }
    }

    private void fixDisconnectedNodes(List<Integer> disconnectedNodes, int level, UpdateableRandomVectorScorer scorer) throws IOException {
        if (disconnectedNodes.isEmpty()) {
            return;
        }
        int beamWidth = this.beamCandidates.k();
        HnswGraphBuilder.GraphBuilderKnnCollector candidates = new HnswGraphBuilder.GraphBuilderKnnCollector(beamWidth);
        NeighborArray scratchArray = new NeighborArray(beamWidth, false);
        for (int node : disconnectedNodes) {
            scorer.setScoringOrdinal(node);
            NeighborArray existingNeighbors = this.hnsw.getNeighbors(level, node);
            if (existingNeighbors.size() > 0) {
                int[] entryPoints = new int[existingNeighbors.size()];
                System.arraycopy(existingNeighbors.nodes(), 0, entryPoints, 0, existingNeighbors.size());
                this.graphSearcher.searchLevel(candidates, scorer, level, entryPoints, this.hnsw, null);
                InitializedHnswGraphBuilder.popToScratch(candidates, scratchArray);
                this.addDiverseNeighbors(level, node, scratchArray, scorer, true);
            } else {
                this.addConnections(node, level, scorer);
            }
            scratchArray.clear();
            candidates.clear();
        }
    }

    private void rebalanceGraph() throws IOException {
        int maxNodesAtLevel;
        SplittableRandom random = new SplittableRandom();
        int size = this.hnsw.size();
        double invMaxConn = 1.0 / (double)this.M;
        int level = 1;
        while ((maxNodesAtLevel = (int)((double)size * Math.pow(invMaxConn, level))) > 0) {
            int currentNodesAtLevel = 0;
            if (level >= this.levelToNodes.length) {
                this.levelToNodes = ArrayUtil.growExact(this.levelToNodes, level + 1);
                this.levelToNodes[level] = new IntArrayList();
            } else {
                currentNodesAtLevel = this.levelToNodes[level].size();
            }
            if (currentNodesAtLevel < maxNodesAtLevel) {
                Iterator<IntCursor> it = this.levelToNodes[level - 1].iterator();
                while (it.hasNext() && currentNodesAtLevel < maxNodesAtLevel) {
                    int node = it.next().value;
                    if (!(random.nextDouble() < invMaxConn) || this.hnsw.nodeExistAtLevel(level, node)) continue;
                    this.scorer.setScoringOrdinal(node);
                    this.hnsw.addNode(level, node);
                    if (currentNodesAtLevel == 0) {
                        this.hnsw.tryPromoteNewEntryNode(node, level, this.hnsw.numLevels() - 1);
                    } else {
                        this.addConnections(node, level, this.scorer);
                    }
                    this.levelToNodes[level].add(node);
                    ++currentNodesAtLevel;
                }
            }
            ++level;
        }
    }

    private void addConnections(int node, int targetLevel, UpdateableRandomVectorScorer scorer) throws IOException {
        int beamWidth = this.beamCandidates.k();
        HnswGraphBuilder.GraphBuilderKnnCollector candidates = new HnswGraphBuilder.GraphBuilderKnnCollector(beamWidth);
        int[] eps = new int[]{this.hnsw.entryNode()};
        for (int level = this.hnsw.numLevels() - 1; level > targetLevel; --level) {
            this.graphSearcher.searchLevel(candidates, scorer, level, eps, this.hnsw, null);
            eps[0] = candidates.popNode();
            candidates.clear();
        }
        this.graphSearcher.searchLevel(candidates, scorer, targetLevel, eps, this.hnsw, null);
        NeighborArray scratchArray = new NeighborArray(beamWidth, false);
        InitializedHnswGraphBuilder.popToScratch(candidates, scratchArray);
        this.addDiverseNeighbors(targetLevel, node, scratchArray, scorer, true);
    }

    @Override
    public void addGraphNode(int node) throws IOException {
        if (this.initializedNodes.get(node)) {
            return;
        }
        super.addGraphNode(node);
    }
}

