/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.index.FreqAndNormBuffer;
import org.apache.lucene.index.Impacts;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.ImpactsSource;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.ImpactsDISI;
import org.apache.lucene.search.MaxScoreCache;
import org.apache.lucene.search.PhraseMatcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.PriorityQueue;

public final class ExactPhraseMatcher
extends PhraseMatcher {
    private final PostingsAndPosition[] postings;
    private final DocIdSetIterator approximation;
    private final ImpactsDISI impactsApproximation;

    public ExactPhraseMatcher(PhraseQuery.PostingsAndFreq[] postings, ScoreMode scoreMode, Similarity.SimScorer scorer, float matchCost) {
        super(matchCost);
        DocIdSetIterator approximation = ConjunctionUtils.intersectIterators(Arrays.stream(postings).map(p -> p.postings).toList());
        ImpactsSource impactsSource = ExactPhraseMatcher.mergeImpacts((ImpactsEnum[])Arrays.stream(postings).map(p -> p.impacts).toArray(ImpactsEnum[]::new));
        this.impactsApproximation = new ImpactsDISI(approximation, new MaxScoreCache(impactsSource, scorer));
        this.approximation = scoreMode == ScoreMode.TOP_SCORES ? this.impactsApproximation : approximation;
        ArrayList<PostingsAndPosition> postingsAndPositions = new ArrayList<PostingsAndPosition>();
        for (PhraseQuery.PostingsAndFreq posting : postings) {
            postingsAndPositions.add(new PostingsAndPosition(posting.postings, posting.position));
        }
        this.postings = postingsAndPositions.toArray(new PostingsAndPosition[0]);
    }

    @Override
    DocIdSetIterator approximation() {
        return this.approximation;
    }

    @Override
    ImpactsDISI impactsApproximation() {
        return this.impactsApproximation;
    }

    @Override
    float maxFreq() {
        int minFreq = this.postings[0].freq;
        for (int i = 1; i < this.postings.length; ++i) {
            minFreq = Math.min(minFreq, this.postings[i].freq);
        }
        return minFreq;
    }

    private static boolean advancePosition(PostingsAndPosition posting, int target) throws IOException {
        while (posting.pos < target) {
            if (posting.upTo == posting.freq) {
                return false;
            }
            posting.pos = posting.postings.nextPosition();
            ++posting.upTo;
        }
        return true;
    }

    @Override
    public void reset() throws IOException {
        for (PostingsAndPosition posting : this.postings) {
            posting.freq = posting.postings.freq();
            posting.pos = -1;
            posting.upTo = 0;
        }
    }

    @Override
    public boolean nextMatch() throws IOException {
        block6: {
            PostingsAndPosition lead = this.postings[0];
            if (lead.upTo < lead.freq) {
                lead.pos = lead.postings.nextPosition();
                ++lead.upTo;
            } else {
                return false;
            }
            block0: while (true) {
                int phrasePos = lead.pos - lead.offset;
                for (int j = 1; j < this.postings.length; ++j) {
                    PostingsAndPosition posting = this.postings[j];
                    int expectedPos = phrasePos + posting.offset;
                    if (ExactPhraseMatcher.advancePosition(posting, expectedPos)) {
                        if (posting.pos == expectedPos) continue;
                        if (ExactPhraseMatcher.advancePosition(lead, posting.pos - posting.offset + lead.offset)) {
                            continue block0;
                        }
                    }
                    break block6;
                }
                break;
            }
            return true;
        }
        return false;
    }

    @Override
    float sloppyWeight() {
        return 1.0f;
    }

    @Override
    public int startPosition() {
        return this.postings[0].pos;
    }

    @Override
    public int endPosition() {
        return this.postings[this.postings.length - 1].pos;
    }

    @Override
    public int startOffset() throws IOException {
        return this.postings[0].postings.startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        return this.postings[this.postings.length - 1].postings.endOffset();
    }

    static ImpactsSource mergeImpacts(final ImpactsEnum[] impactsEnums) {
        int tmpLeadIndex = -1;
        for (int i = 0; i < impactsEnums.length; ++i) {
            if (tmpLeadIndex != -1 && impactsEnums[i].cost() >= impactsEnums[tmpLeadIndex].cost()) continue;
            tmpLeadIndex = i;
        }
        final int leadIndex = tmpLeadIndex;
        return new ImpactsSource(){

            @Override
            public Impacts getImpacts() throws IOException {
                final Impacts[] impacts = new Impacts[impactsEnums.length];
                for (int i = 0; i < impactsEnums.length; ++i) {
                    impacts[i] = impactsEnums[i].getImpacts();
                }
                final Impacts lead = impacts[leadIndex];
                return new Impacts(this){
                    private final FreqAndNormBuffer mergedImpacts = new FreqAndNormBuffer();
                    {
                        this.mergedImpacts.growNoCopy(1);
                    }

                    @Override
                    public int numLevels() {
                        return lead.numLevels();
                    }

                    @Override
                    public int getDocIdUpTo(int level) {
                        return lead.getDocIdUpTo(level);
                    }

                    private int getLevel(Impacts impacts2, int docIdUpTo) {
                        int numLevels = impacts2.numLevels();
                        for (int level = 0; level < numLevels; ++level) {
                            if (impacts2.getDocIdUpTo(level) < docIdUpTo) continue;
                            return level;
                        }
                        return -1;
                    }

                    @Override
                    public FreqAndNormBuffer getImpacts(int level) {
                        int docIdUpTo = this.getDocIdUpTo(level);
                        PriorityQueue<SubIterator> pq = new PriorityQueue<SubIterator>(this, impacts.length){

                            @Override
                            protected boolean lessThan(SubIterator a, SubIterator b) {
                                return a.freq < b.freq;
                            }
                        };
                        boolean hasImpacts = false;
                        FreqAndNormBuffer onlyImpactList = null;
                        ArrayList<SubIterator> subIterators = new ArrayList<SubIterator>(impacts.length);
                        for (int i = 0; i < impacts.length; ++i) {
                            int impactsLevel = this.getLevel(impacts[i], docIdUpTo);
                            if (impactsLevel == -1) continue;
                            FreqAndNormBuffer impactList = impacts[i].getImpacts(impactsLevel);
                            if (impactList.freqs[0] == Integer.MAX_VALUE && impactList.norms[0] == 1L) continue;
                            SubIterator subIterator = new SubIterator(impactList);
                            subIterators.add(subIterator);
                            if (!hasImpacts) {
                                hasImpacts = true;
                                onlyImpactList = impactList;
                                continue;
                            }
                            onlyImpactList = null;
                        }
                        if (!hasImpacts) {
                            this.mergedImpacts.freqs[0] = Integer.MAX_VALUE;
                            this.mergedImpacts.norms[0] = 1L;
                            this.mergedImpacts.size = 1;
                            return this.mergedImpacts;
                        }
                        if (onlyImpactList != null) {
                            return onlyImpactList;
                        }
                        pq.addAll(subIterators);
                        this.mergedImpacts.size = 0;
                        SubIterator top = (SubIterator)pq.top();
                        int currentFreq = top.freq;
                        long currentNorm = 0L;
                        for (SubIterator it : pq) {
                            if (Long.compareUnsigned(it.norm, currentNorm) <= 0) continue;
                            currentNorm = it.norm;
                        }
                        block2: while (true) {
                            if (this.mergedImpacts.size > 0 && this.mergedImpacts.norms[this.mergedImpacts.size - 1] == currentNorm) {
                                this.mergedImpacts.freqs[this.mergedImpacts.size - 1] = currentFreq;
                            } else {
                                this.mergedImpacts.add(currentFreq, currentNorm);
                            }
                            do {
                                top.next();
                                if (top.exhausted) break block2;
                                if (Long.compareUnsigned(top.norm, currentNorm) > 0) {
                                    currentNorm = top.norm;
                                }
                                top = (SubIterator)pq.updateTop();
                            } while (top.freq == currentFreq);
                            currentFreq = top.freq;
                        }
                        return this.mergedImpacts;
                    }
                };
            }

            @Override
            public void advanceShallow(int target) throws IOException {
                for (ImpactsEnum impactsEnum : impactsEnums) {
                    impactsEnum.advanceShallow(target);
                }
            }

            static class SubIterator {
                final FreqAndNormBuffer buffer;
                int index;
                int freq;
                long norm;
                boolean exhausted;

                SubIterator(FreqAndNormBuffer buffer) {
                    this.buffer = buffer;
                    this.index = 0;
                    this.next();
                }

                void next() {
                    if (this.index >= this.buffer.size) {
                        this.exhausted = true;
                    } else {
                        this.freq = this.buffer.freqs[this.index];
                        this.norm = this.buffer.norms[this.index];
                        ++this.index;
                    }
                }
            }
        };
    }

    private static class PostingsAndPosition {
        private final PostingsEnum postings;
        private final int offset;
        private int freq;
        private int upTo;
        private int pos;

        public PostingsAndPosition(PostingsEnum postings, int offset) {
            this.postings = postings;
            this.offset = offset;
        }
    }
}

