/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene90;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.backward_codecs.lucene90.Lucene90SkipReader;
import org.apache.lucene.index.FreqAndNormBuffer;
import org.apache.lucene.index.Impacts;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;

final class Lucene90ScoreSkipReader
extends Lucene90SkipReader {
    private final byte[][] impactData;
    private final int[] impactDataLength;
    private final ByteArrayDataInput badi = new ByteArrayDataInput();
    private final Impacts impacts;
    private int numLevels = 1;
    private final FreqAndNormBuffer[] perLevelImpacts;

    public Lucene90ScoreSkipReader(IndexInput skipStream, int maxSkipLevels, boolean hasPos, boolean hasOffsets, boolean hasPayloads) {
        super(skipStream, maxSkipLevels, hasPos, hasOffsets, hasPayloads);
        this.impactData = new byte[maxSkipLevels][];
        Arrays.fill((Object[])this.impactData, new byte[0]);
        this.impactDataLength = new int[maxSkipLevels];
        this.perLevelImpacts = new FreqAndNormBuffer[maxSkipLevels];
        for (int i = 0; i < this.perLevelImpacts.length; ++i) {
            this.perLevelImpacts[i] = new FreqAndNormBuffer();
            this.perLevelImpacts[i].add(Integer.MAX_VALUE, 1L);
        }
        this.impacts = new Impacts(){

            public int numLevels() {
                return Lucene90ScoreSkipReader.this.numLevels;
            }

            public int getDocIdUpTo(int level) {
                return Lucene90ScoreSkipReader.this.skipDoc[level];
            }

            public FreqAndNormBuffer getImpacts(int level) {
                assert (level < Lucene90ScoreSkipReader.this.numLevels);
                if (Lucene90ScoreSkipReader.this.impactDataLength[level] > 0) {
                    Lucene90ScoreSkipReader.this.badi.reset(Lucene90ScoreSkipReader.this.impactData[level], 0, Lucene90ScoreSkipReader.this.impactDataLength[level]);
                    Lucene90ScoreSkipReader.this.perLevelImpacts[level] = Lucene90ScoreSkipReader.readImpacts(Lucene90ScoreSkipReader.this.badi, Lucene90ScoreSkipReader.this.perLevelImpacts[level]);
                    Lucene90ScoreSkipReader.this.impactDataLength[level] = 0;
                }
                return Lucene90ScoreSkipReader.this.perLevelImpacts[level];
            }
        };
    }

    public int skipTo(int target) throws IOException {
        int result = super.skipTo(target);
        if (this.numberOfSkipLevels > 0) {
            this.numLevels = this.numberOfSkipLevels;
        } else {
            this.numLevels = 1;
            this.perLevelImpacts[0].size = 1;
            this.perLevelImpacts[0].freqs[0] = Integer.MAX_VALUE;
            this.perLevelImpacts[0].norms[0] = 1L;
            this.impactDataLength[0] = 0;
        }
        return result;
    }

    Impacts getImpacts() {
        return this.impacts;
    }

    @Override
    protected void readImpacts(int level, IndexInput skipStream) throws IOException {
        int length = skipStream.readVInt();
        if (this.impactData[level].length < length) {
            this.impactData[level] = new byte[ArrayUtil.oversize((int)length, (int)1)];
        }
        skipStream.readBytes(this.impactData[level], 0, length);
        this.impactDataLength[level] = length;
    }

    static FreqAndNormBuffer readImpacts(ByteArrayDataInput in, FreqAndNormBuffer reuse) {
        int maxNumImpacts = in.length();
        reuse.growNoCopy(maxNumImpacts);
        int freq = 0;
        long norm = 0L;
        int size = 0;
        while (in.getPosition() < in.length()) {
            int freqDelta = in.readVInt();
            if ((freqDelta & 1) != 0) {
                freq += 1 + (freqDelta >>> 1);
                try {
                    norm += 1L + in.readZLong();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                freq += 1 + (freqDelta >>> 1);
            }
            reuse.freqs[size] = freq;
            reuse.norms[size] = ++norm;
            ++size;
        }
        reuse.size = size;
        return reuse;
    }
}

