/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.fragments.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.TableColumnInfo;
import org.apache.lucene.luke.app.desktop.components.TableModelBase;
import org.apache.lucene.luke.app.desktop.components.fragments.search.FieldValuesTabOperator;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.TableUtils;

public final class FieldValuesPaneProvider
implements FieldValuesTabOperator {
    private final JCheckBox loadAllCB = new JCheckBox();
    private final JTable fieldsTable = new JTable();
    private ListenerFunctions listners = new ListenerFunctions();

    public FieldValuesPaneProvider() {
        ComponentOperatorRegistry.getInstance().register(FieldValuesTabOperator.class, this);
    }

    public JScrollPane get() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this.initFieldsConfigPanel());
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        return scrollPane;
    }

    private JPanel initFieldsConfigPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        JPanel header = new JPanel(new GridLayout(1, 2));
        header.setOpaque(false);
        header.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        header.add(new JLabel(MessageUtils.getLocalizedMessage("search_values.label.description")));
        this.loadAllCB.setText(MessageUtils.getLocalizedMessage("search_values.checkbox.load_all"));
        this.loadAllCB.setSelected(true);
        this.loadAllCB.addActionListener(this.listners::loadAllFields);
        this.loadAllCB.setOpaque(false);
        header.add(this.loadAllCB);
        panel.add((Component)header, "First");
        TableUtils.setupTable(this.fieldsTable, 0, new FieldsTableModel(), null, FieldsTableModel.Column.LOAD.getColumnWidth());
        this.fieldsTable.setShowGrid(true);
        this.fieldsTable.setPreferredScrollableViewportSize(this.fieldsTable.getPreferredSize());
        panel.add((Component)new JScrollPane(this.fieldsTable), "Center");
        return panel;
    }

    @Override
    public void setFields(Collection<String> fields) {
        this.fieldsTable.setModel(new FieldsTableModel(fields));
        this.fieldsTable.getColumnModel().getColumn(FieldsTableModel.Column.LOAD.getIndex()).setMinWidth(FieldsTableModel.Column.LOAD.getColumnWidth());
        this.fieldsTable.getColumnModel().getColumn(FieldsTableModel.Column.LOAD.getIndex()).setMaxWidth(FieldsTableModel.Column.LOAD.getColumnWidth());
        this.fieldsTable.getModel().addTableModelListener(this.listners::tableDataChenged);
    }

    @Override
    public Set<String> getFieldsToLoad() {
        HashSet<String> fieldsToLoad = new HashSet<String>();
        for (int row = 0; row < this.fieldsTable.getRowCount(); ++row) {
            boolean loaded = (Boolean)this.fieldsTable.getValueAt(row, FieldsTableModel.Column.LOAD.getIndex());
            if (!loaded) continue;
            fieldsToLoad.add((String)this.fieldsTable.getValueAt(row, FieldsTableModel.Column.FIELD.getIndex()));
        }
        return fieldsToLoad;
    }

    class ListenerFunctions {
        ListenerFunctions() {
        }

        void loadAllFields(ActionEvent e) {
            for (int i = 0; i < FieldValuesPaneProvider.this.fieldsTable.getModel().getRowCount(); ++i) {
                if (FieldValuesPaneProvider.this.loadAllCB.isSelected()) {
                    FieldValuesPaneProvider.this.fieldsTable.setValueAt(true, i, FieldsTableModel.Column.LOAD.getIndex());
                    continue;
                }
                FieldValuesPaneProvider.this.fieldsTable.setValueAt(false, i, FieldsTableModel.Column.LOAD.getIndex());
            }
        }

        void tableDataChenged(TableModelEvent e) {
            boolean isLoad;
            int row = e.getFirstRow();
            int col = e.getColumn();
            if (col == FieldsTableModel.Column.LOAD.getIndex() && !(isLoad = ((Boolean)FieldValuesPaneProvider.this.fieldsTable.getModel().getValueAt(row, col)).booleanValue())) {
                FieldValuesPaneProvider.this.loadAllCB.setSelected(false);
            }
        }
    }

    static final class FieldsTableModel
    extends TableModelBase<Column> {
        FieldsTableModel() {
        }

        FieldsTableModel(Collection<String> fields) {
            super(fields.size());
            int i = 0;
            for (String field : fields) {
                this.data[i][Column.LOAD.getIndex()] = true;
                this.data[i][Column.FIELD.getIndex()] = field;
                ++i;
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == Column.LOAD.getIndex();
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            this.data[rowIndex][columnIndex] = value;
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            LOAD("Load", 0, Boolean.class, 50),
            FIELD("Field", 1, String.class, Integer.MAX_VALUE);

            private final String colName;
            private final int index;
            private final Class<?> type;
            private final int width;

            private Column(String colName, int index, Class<?> type, int width) {
                this.colName = colName;
                this.index = index;
                this.type = type;
                this.width = width;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public int getColumnWidth() {
                return this.width;
            }
        }
    }
}

