/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser.lang.es;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import opennlp.tools.parser.Constituent;
import opennlp.tools.parser.GapLabeler;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class AncoraSpanishHeadRules
implements HeadRules,
GapLabeler,
SerializableArtifact {
    private Map<String, HeadRule> headRules;
    private final Set<String> punctSet;

    public AncoraSpanishHeadRules(Reader rulesReader) throws IOException {
        BufferedReader in = new BufferedReader(rulesReader);
        this.readHeadRules(in);
        this.punctSet = new HashSet<String>();
        this.punctSet.add(".");
        this.punctSet.add(",");
        this.punctSet.add("``");
        this.punctSet.add("''");
    }

    @Override
    public Set<String> getPunctuationTags() {
        return this.punctSet;
    }

    @Override
    public Parse getHead(Parse[] constituents, String type) {
        if ("TK".equals(constituents[0].getType())) {
            return null;
        }
        if (type.equals("SN") || type.equals("GRUP.NOM")) {
            String[] tags1 = new String[]{"AQA.*", "AQC.*", "GRUP\\.A", "S\\.A", "NC.*S.*", "NP.*", "NC.*P.*", "GRUP\\.NOM"};
            for (Parse constituent : constituents) {
                for (int t = tags1.length - 1; t >= 0; --t) {
                    if (!constituent.getType().matches(tags1[t])) continue;
                    return constituent;
                }
            }
            for (Parse constituent : constituents) {
                if (!constituent.getType().equals("SN") && !constituent.getType().equals("GRUP.NOM")) continue;
                return constituent;
            }
            String[] tags2 = new String[]{"\\$", "GRUP\\.A", "SA"};
            for (int ci = constituents.length - 1; ci >= 0; --ci) {
                for (int ti = tags2.length - 1; ti >= 0; --ti) {
                    if (!constituents[ci].getType().matches(tags2[ti])) continue;
                    return constituents[ci];
                }
            }
            String[] tags3 = new String[]{"AQ0.*", "AQ[AC].*", "AO.*", "GRUP\\.A", "S\\.A", "RG", "RN", "GRUP\\.NOM"};
            for (int ci = constituents.length - 1; ci >= 0; --ci) {
                for (int ti = tags3.length - 1; ti >= 0; --ti) {
                    if (!constituents[ci].getType().matches(tags3[ti])) continue;
                    return constituents[ci];
                }
            }
            return constituents[constituents.length - 1].getHead();
        }
        HeadRule hr = this.headRules.get(type);
        if (hr != null) {
            String[] tags = hr.tags;
            int cl = constituents.length;
            int tl = tags.length;
            if (hr.leftToRight) {
                for (String tag : tags) {
                    for (Parse constituent : constituents) {
                        if (!constituent.getType().matches(tag)) continue;
                        return constituent;
                    }
                }
                return constituents[0].getHead();
            }
            for (String tag : tags) {
                for (int ci = cl - 1; ci >= 0; --ci) {
                    if (!constituents[ci].getType().matches(tag)) continue;
                    return constituents[ci];
                }
            }
            return constituents[cl - 1].getHead();
        }
        return constituents[constituents.length - 1].getHead();
    }

    private void readHeadRules(BufferedReader str) throws IOException {
        String line;
        this.headRules = new HashMap<String, HeadRule>(60);
        while ((line = str.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            String num = st.nextToken();
            String type = st.nextToken();
            String dir = st.nextToken();
            String[] tags = new String[Integer.parseInt(num) - 2];
            int ti = 0;
            while (st.hasMoreTokens()) {
                tags[ti] = st.nextToken();
                ++ti;
            }
            this.headRules.put(type, new HeadRule(dir.equals("1"), tags));
        }
    }

    @Override
    public void labelGaps(Stack<Constituent> stack) {
        if (stack.size() > 4) {
            Constituent con1 = (Constituent)stack.get(stack.size() - 2);
            Constituent con2 = (Constituent)stack.get(stack.size() - 3);
            Constituent con3 = (Constituent)stack.get(stack.size() - 4);
            Constituent con4 = (Constituent)stack.get(stack.size() - 5);
            if (con1.getLabel().equals("SN") && con2.getLabel().equals("S") && con3.getLabel().equals("GRUP.NOM")) {
                con1.setLabel(con1.getLabel() + "-G");
                con2.setLabel(con2.getLabel() + "-G");
                con3.setLabel(con3.getLabel() + "-G");
            } else if (con1.getLabel().equals("SN") && con2.getLabel().equals("GRUP.VERB") && con3.getLabel().equals("S") && con4.getLabel().equals("GRUP.NOM")) {
                con1.setLabel(con1.getLabel() + "-G");
                con2.setLabel(con2.getLabel() + "-G");
                con3.setLabel(con3.getLabel() + "-G");
                con4.setLabel(con4.getLabel() + "-G");
            }
        }
    }

    public void serialize(Writer writer) throws IOException {
        for (Map.Entry<String, HeadRule> entry : this.headRules.entrySet()) {
            String type = entry.getKey();
            HeadRule headRule = entry.getValue();
            writer.write(Integer.toString(headRule.tags.length + 2));
            writer.write(32);
            writer.write(type);
            writer.write(32);
            if (headRule.leftToRight) {
                writer.write("1");
            } else {
                writer.write("0");
            }
            for (String tag : headRule.tags) {
                writer.write(32);
                writer.write(tag);
            }
            writer.write(10);
        }
        writer.flush();
    }

    public int hashCode() {
        return Objects.hash(this.headRules, this.punctSet);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AncoraSpanishHeadRules) {
            AncoraSpanishHeadRules rules = (AncoraSpanishHeadRules)obj;
            return rules.headRules.equals(this.headRules) && rules.punctSet.equals(this.punctSet);
        }
        return false;
    }

    @Override
    public Class<?> getArtifactSerializerClass() {
        return HeadRulesSerializer.class;
    }

    private static class HeadRule {
        public final boolean leftToRight;
        public final String[] tags;

        public HeadRule(boolean l2r, String[] tags) {
            this.leftToRight = l2r;
            for (String tag : tags) {
                Objects.requireNonNull(tag, "tags must not contain null values!");
            }
            this.tags = tags;
        }

        public int hashCode() {
            return Objects.hash(this.leftToRight, Arrays.hashCode(this.tags));
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof HeadRule) {
                HeadRule rule = (HeadRule)obj;
                return rule.leftToRight == this.leftToRight && Arrays.equals(rule.tags, this.tags);
            }
            return false;
        }
    }

    public static class HeadRulesSerializer
    implements ArtifactSerializer<AncoraSpanishHeadRules> {
        @Override
        public AncoraSpanishHeadRules create(InputStream in) throws IOException {
            return new AncoraSpanishHeadRules(new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)));
        }

        @Override
        public void serialize(AncoraSpanishHeadRules artifact, OutputStream out) throws IOException {
            artifact.serialize(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        }
    }
}

