/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.operation.OperationManager;
import org.apache.kyuubi.service.CompositeService;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionManager$;
import org.apache.kyuubi.session.package$;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.util.ThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t-f!B\u001e=\u0003\u0003)\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u000bi\u0003A\u0011A.\t\u000f}\u0003\u0001\u0019!C\u0005A\"9Q\r\u0001a\u0001\n\u00131\u0007B\u00027\u0001A\u0003&\u0011\rC\u0004r\u0001\u0001\u0007I\u0011\u0003:\t\u000fY\u0004\u0001\u0019!C\to\"1\u0011\u0010\u0001Q!\nMDQA\u001f\u0001\u0005\u0002IDQa\u001f\u0001\u0005\nqDq! \u0001A\u0002\u0013%a\u0010C\u0005\u0002\u0006\u0001\u0001\r\u0011\"\u0003\u0002\b!9\u00111\u0002\u0001!B\u0013y\bBBA\b\u0001\u0011\u0005a\u0010C\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0003\u0002\u0014!A\u0011Q\u0007\u0001!\u0002\u0013\t)\u0002C\u0005\u00028\u0001\u0011\r\u0011\"\u0003\u0002:!A\u0011\u0011\t\u0001!\u0002\u0013\tY\u0004\u0003\u0004\u0002D\u00011\t\u0002\u0019\u0005\f\u0003\u000b\u0002\u0001\u0019!a\u0001\n\u0013\t9\u0005C\u0006\u0002P\u0001\u0001\r\u00111A\u0005\n\u0005E\u0003bCA+\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0013Bq!a\u0016\u0001\t\u0003\tI\u0006C\u0004\u0002\n\u00021\t!a#\t\u000f\u0005e\u0005A\"\u0005\u0002\u001c\"9\u0011\u0011\u001b\u0001\u0005\u0012\u0005M\u0007bBAn\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0003S\u0004A\u0011AAv\u0011\u001d\t\t\u0010\u0001C\u0005\u0003gDq!a>\u0001\t\u0003\tI\u0010C\u0004\u0002\u0000\u0002!\tA!\u0001\t\u000f\t\u0015\u0001\u0001\"\u0006\u0003\b!9!Q\u0002\u0001\u0005\u0002\t=\u0001b\u0002B\f\u0001\u0011\u0005!\u0011\u0004\u0005\b\u0005[\u0001A\u0011\u0001B\b\u0011\u001d\u0011y\u0003\u0001C\u0001\u0005\u001fAqA!\r\u0001\t\u0003\u0011y\u0001C\u0006\u00034\u0001\u0001\r\u00111A\u0005\n\tU\u0002b\u0003B\u001f\u0001\u0001\u0007\t\u0019!C\u0005\u0005\u007fA1Ba\u0011\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00038!Y!Q\t\u0001A\u0002\u0003\u0007I\u0011\u0002B\u001b\u0011-\u00119\u0005\u0001a\u0001\u0002\u0004%IA!\u0013\t\u0017\t5\u0003\u00011A\u0001B\u0003&!q\u0007\u0005\f\u0005\u001f\u0002\u0001\u0019!a\u0001\n\u0013\u0011)\u0004C\u0006\u0003R\u0001\u0001\r\u00111A\u0005\n\tM\u0003b\u0003B,\u0001\u0001\u0007\t\u0011)Q\u0005\u0005oA!B!\u0017\u0001\u0011\u000b\u0007I\u0011\u0002B\u001b\u0011)\u0011Y\u0006\u0001EC\u0002\u0013%!Q\u0007\u0005\u000b\u0005;\u0002\u0001R1A\u0005\n\tU\u0002b\u0002B0\u0001\u0011\u0005!\u0011\r\u0005\b\u0005g\u0002A\u0011\u0001B;\u0011\u001d\u0011Y\b\u0001C\u0001\u0005{BqAa!\u0001\t\u0003\u0011)\tC\u0004\u0003\n\u0002!\tEa#\t\r\te\u0005\u0001\"\u0011}\u0011\u0019\u0011Y\n\u0001C!y\"1!Q\u0014\u0001\u0005\nqD\u0001Ba(\u0001\t\u0003q$\u0011\u0015\u0002\u000f'\u0016\u001c8/[8o\u001b\u0006t\u0017mZ3s\u0015\tid(A\u0004tKN\u001c\u0018n\u001c8\u000b\u0005}\u0002\u0015AB6zkV\u0014\u0017N\u0003\u0002B\u0005\u00061\u0011\r]1dQ\u0016T\u0011aQ\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0019\u0003\"a\u0012&\u000e\u0003!S!!\u0013 \u0002\u000fM,'O^5dK&\u00111\n\u0013\u0002\u0011\u0007>l\u0007o\\:ji\u0016\u001cVM\u001d<jG\u0016\fAA\\1nKB\u0011aj\u0016\b\u0003\u001fV\u0003\"\u0001U*\u000e\u0003ES!A\u0015#\u0002\rq\u0012xn\u001c;?\u0015\u0005!\u0016!B:dC2\f\u0017B\u0001,T\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001,\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y\u001b\u0016A\u0002\u001fj]&$h\b\u0006\u0002]=B\u0011Q\fA\u0007\u0002y!)AJ\u0001a\u0001\u001b\u0006A1\u000f[;uI><h.F\u0001b!\t\u00117-D\u0001T\u0013\t!7KA\u0004C_>dW-\u00198\u0002\u0019MDW\u000f\u001e3po:|F%Z9\u0015\u0005\u001dT\u0007C\u00012i\u0013\tI7K\u0001\u0003V]&$\bbB6\u0005\u0003\u0003\u0005\r!Y\u0001\u0004q\u0012\n\u0014!C:ikR$wn\u001e8!Q\t)a\u000e\u0005\u0002c_&\u0011\u0001o\u0015\u0002\tm>d\u0017\r^5mK\u0006\trl\u001c9fe\u0006$\u0018n\u001c8M_\u001e\u0014vn\u001c;\u0016\u0003M\u00042A\u0019;N\u0013\t)8K\u0001\u0004PaRLwN\\\u0001\u0016?>\u0004XM]1uS>tGj\\4S_>$x\fJ3r)\t9\u0007\u0010C\u0004l\u000f\u0005\u0005\t\u0019A:\u0002%}{\u0007/\u001a:bi&|g\u000eT8h%>|G\u000fI\u0001\u0011_B,'/\u0019;j_:dun\u001a*p_R\fq#\u001b8ji>\u0003XM]1uS>tGj\\4S_>$H)\u001b:\u0015\u0003\u001d\f\u0011c\u00187bi\u0016\u001cH\u000fT8h_V$H+[7f+\u0005y\bc\u00012\u0002\u0002%\u0019\u00111A*\u0003\t1{gnZ\u0001\u0016?2\fG/Z:u\u0019><w.\u001e;US6,w\fJ3r)\r9\u0017\u0011\u0002\u0005\bW2\t\t\u00111\u0001\u0000\u0003IyF.\u0019;fgRdunZ8viRKW.\u001a\u0011)\u00055q\u0017\u0001\u00057bi\u0016\u001cH\u000fT8h_V$H+[7f\u0003=A\u0017M\u001c3mKR{7+Z:tS>tWCAA\u000b!!\t9\"!\n\u0002*\u0005=RBAA\r\u0015\u0011\tY\"!\b\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002 \u0005\u0005\u0012\u0001B;uS2T!!a\t\u0002\t)\fg/Y\u0005\u0005\u0003O\tIBA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u00042!XA\u0016\u0013\r\ti\u0003\u0010\u0002\u000e'\u0016\u001c8/[8o\u0011\u0006tG\r\\3\u0011\u0007u\u000b\t$C\u0002\u00024q\u0012qaU3tg&|g.\u0001\tiC:$G.\u001a+p'\u0016\u001c8/[8oA\u0005qA/[7f_V$8\t[3dW\u0016\u0014XCAA\u001e!\u0011\t9\"!\u0010\n\t\u0005}\u0012\u0011\u0004\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017a\u0004;j[\u0016|W\u000f^\"iK\u000e\\WM\u001d\u0011\u0002\u0011%\u001c8+\u001a:wKJ\f\u0001\"\u001a=fGB{w\u000e\\\u000b\u0003\u0003\u0013\u0002B!a\u0006\u0002L%!\u0011QJA\r\u0005I!\u0006N]3bIB{w\u000e\\#yK\u000e,Ho\u001c:\u0002\u0019\u0015DXm\u0019)p_2|F%Z9\u0015\u0007\u001d\f\u0019\u0006\u0003\u0005l+\u0005\u0005\t\u0019AA%\u0003%)\u00070Z2Q_>d\u0007%A\rtk\nl\u0017\u000e\u001e\"bG.<'o\\;oI>\u0003XM]1uS>tG\u0003BA.\u0003s\u0002D!!\u0018\u0002hA1\u0011qCA0\u0003GJA!!\u0019\u0002\u001a\t1a)\u001e;ve\u0016\u0004B!!\u001a\u0002h1\u0001AaCA5/\u0005\u0005\t\u0011!B\u0001\u0003W\u00121a\u0018\u00132#\u0011\ti'a\u001d\u0011\u0007\t\fy'C\u0002\u0002rM\u0013qAT8uQ&tw\rE\u0002c\u0003kJ1!a\u001eT\u0005\r\te.\u001f\u0005\b\u0003w:\u0002\u0019AA?\u0003\u0005\u0011\b\u0003BA@\u0003\u000bk!!!!\u000b\t\u0005\r\u0015\u0011E\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\b\u0006\u0005%\u0001\u0003*v]:\f'\r\\3\u0002!=\u0004XM]1uS>tW*\u00198bO\u0016\u0014XCAAG!\u0011\ty)!&\u000e\u0005\u0005E%bAAJ}\u0005Iq\u000e]3sCRLwN\\\u0005\u0005\u0003/\u000b\tJ\u0001\tPa\u0016\u0014\u0018\r^5p]6\u000bg.Y4fe\u0006i1M]3bi\u0016\u001cVm]:j_:$B\"a\f\u0002\u001e\u0006m\u0016qXAb\u0003\u000fDq!a(\u001a\u0001\u0004\t\t+\u0001\u0005qe>$xnY8m!\u0011\t\u0019+a.\u000e\u0005\u0005\u0015&\u0002BAT\u0003S\u000ba\u0001\u001e5sS\u001a$(\u0002BAV\u0003[\u000b1A\u001d9d\u0015\rI\u0015q\u0016\u0006\u0005\u0003c\u000b\u0019,\u0001\u0003iSZ,'bAA[}\u000511\u000f[1eK\u0012LA!!/\u0002&\n\u0001B\u000b\u0015:pi>\u001cw\u000e\u001c,feNLwN\u001c\u0005\u0007\u0003{K\u0002\u0019A'\u0002\tU\u001cXM\u001d\u0005\u0007\u0003\u0003L\u0002\u0019A'\u0002\u0011A\f7o]<pe\u0012Da!!2\u001a\u0001\u0004i\u0015!C5q\u0003\u0012$'/Z:t\u0011\u001d\tI-\u0007a\u0001\u0003\u0017\fAaY8oMB)a*!4N\u001b&\u0019\u0011qZ-\u0003\u00075\u000b\u0007/A\nm_\u001e\u001cVm]:j_:\u001cu.\u001e8u\u0013:4w\u000eF\u0003h\u0003+\f9\u000e\u0003\u0004>5\u0001\u0007\u0011q\u0006\u0005\u0007\u00033T\u0002\u0019A'\u0002\r\u0005\u001cG/[8o\u0003-y\u0007/\u001a8TKN\u001c\u0018n\u001c8\u0015\u0019\u0005%\u0012q\\Aq\u0003G\f)/a:\t\u000f\u0005}5\u00041\u0001\u0002\"\"1\u0011QX\u000eA\u00025Ca!!1\u001c\u0001\u0004i\u0005BBAc7\u0001\u0007Q\nC\u0004\u0002Jn\u0001\r!a3\u0002\u0019\rdwn]3TKN\u001c\u0018n\u001c8\u0015\u0007\u001d\fi\u000fC\u0004\u0002pr\u0001\r!!\u000b\u0002\u001bM,7o]5p]\"\u000bg\u000e\u001a7f\u0003q!W\r\\3uK>\u0003XM]1uS>tGj\\4TKN\u001c\u0018n\u001c8ESJ$2aZA{\u0011\u001d\ty/\ba\u0001\u0003S\t\u0001cZ3u'\u0016\u001c8/[8o\u001fB$\u0018n\u001c8\u0015\t\u0005m\u0018Q \t\u0005ER\fy\u0003C\u0004\u0002pz\u0001\r!!\u000b\u0002\u0015\u001d,GoU3tg&|g\u000e\u0006\u0003\u00020\t\r\u0001bBAx?\u0001\u0007\u0011\u0011F\u0001\u000bg\u0016$8+Z:tS>tG#B4\u0003\n\t-\u0001bBAxA\u0001\u0007\u0011\u0011\u0006\u0005\u0007{\u0001\u0002\r!a\f\u0002'\u001d,Go\u00149f]N+7o]5p]\u000e{WO\u001c;\u0016\u0005\tE\u0001c\u00012\u0003\u0014%\u0019!QC*\u0003\u0007%sG/A\u0006bY2\u001cVm]:j_:\u001cHC\u0001B\u000e!\u0019\u0011iBa\n\u000209!!q\u0004B\u0012\u001d\r\u0001&\u0011E\u0005\u0002)&\u0019!QE*\u0002\u000fA\f7m[1hK&!!\u0011\u0006B\u0016\u0005!IE/\u001a:bE2,'b\u0001B\u0013'\u0006yq-\u001a;Fq\u0016\u001c\u0007k\\8m'&TX-\u0001\bhKR\f5\r^5wK\u000e{WO\u001c;\u0002!\u001d,GoV8sWF+X-^3TSj,\u0017!E0d_:4'+Z:ue&\u001cG\u000fT5tiV\u0011!q\u0007\t\u0005\u001d\neR*C\u0002\u0003<e\u00131aU3u\u0003Uy6m\u001c8g%\u0016\u001cHO]5di2K7\u000f^0%KF$2a\u001aB!\u0011!Yw%!AA\u0002\t]\u0012AE0d_:4'+Z:ue&\u001cG\u000fT5ti\u0002\nqbX2p]\u001aLuM\\8sK2K7\u000f^\u0001\u0014?\u000e|gNZ%h]>\u0014X\rT5ti~#S-\u001d\u000b\u0004O\n-\u0003\u0002C6+\u0003\u0003\u0005\rAa\u000e\u0002!}\u001bwN\u001c4JO:|'/\u001a'jgR\u0004\u0013\u0001F0cCR\u001c\u0007nQ8oM&;gn\u001c:f\u0019&\u001cH/\u0001\r`E\u0006$8\r[\"p]\u001aLuM\\8sK2K7\u000f^0%KF$2a\u001aB+\u0011!YW&!AA\u0002\t]\u0012!F0cCR\u001c\u0007nQ8oM&;gn\u001c:f\u0019&\u001cH\u000fI\u0001\u0017?\u000e|gN\u001a*fgR\u0014\u0018n\u0019;NCR\u001c\u0007\u000eT5ti\u0006!rlY8oM&;gn\u001c:f\u001b\u0006$8\r\u001b'jgR\f\u0011d\u00182bi\u000eD7i\u001c8g\u0013\u001etwN]3NCR\u001c\u0007\u000eT5ti\u0006Ya/\u00197jI\u0006$XmS3z)\u0019\u0011\u0019Ga\u001b\u0003pA!!\r\u001eB3!\u0015\u0011'qM'N\u0013\r\u0011Ig\u0015\u0002\u0007)V\u0004H.\u001a\u001a\t\r\t5$\u00071\u0001N\u0003\rYW-\u001f\u0005\u0007\u0005c\u0012\u0004\u0019A'\u0002\u000bY\fG.^3\u00021Y\fG.\u001b3bi\u0016\fe\u000e\u001a(pe6\fG.\u001b>f\u0007>tg\r\u0006\u0003\u0002L\n]\u0004b\u0002B=g\u0001\u0007\u00111Z\u0001\u0007G>tg-[4\u0002!Y\fG.\u001b3bi\u0016\u0014\u0015\r^2i\u0017\u0016LHC\u0002B2\u0005\u007f\u0012\t\t\u0003\u0004\u0003nQ\u0002\r!\u0014\u0005\u0007\u0005c\"\u0004\u0019A'\u0002#Y\fG.\u001b3bi\u0016\u0014\u0015\r^2i\u0007>tg\r\u0006\u0003\u0002L\n\u001d\u0005b\u0002B=k\u0001\u0007\u00111Z\u0001\u000bS:LG/[1mSj,GcA4\u0003\u000e\"9\u0011\u0011\u001a\u001cA\u0002\t=\u0005\u0003\u0002BI\u0005+k!Aa%\u000b\u0007\ted(\u0003\u0003\u0003\u0018\nM%AC&zkV\u0014\u0017nQ8oM\u0006)1\u000f^1si\u0006!1\u000f^8q\u0003M\u0019H/\u0019:u)&lWm\\;u\u0007\",7m[3s\u0003]\u0019H/\u0019:u)\u0016\u0014X.\u001b8bi&twm\u00115fG.,'\u000fF\u0002h\u0005GCqAa';\u0001\u0004\u0011)\u000b\u0005\u0003c\u0005O;\u0017b\u0001BU'\nIa)\u001e8di&|g\u000e\r")
public abstract class SessionManager
extends CompositeService {
    private Set<String> _confRestrictMatchList;
    private Set<String> _confIgnoreMatchList;
    private Set<String> _batchConfIgnoreMatchList;
    private final String name;
    private volatile boolean org$apache$kyuubi$session$SessionManager$$shutdown;
    private Option<String> _operationLogRoot;
    private volatile long _latestLogoutTime;
    private final ConcurrentHashMap<SessionHandle, Session> org$apache$kyuubi$session$SessionManager$$handleToSession;
    private final ScheduledExecutorService timeoutChecker;
    private ThreadPoolExecutor execPool;
    private Set<String> _confRestrictList;
    private Set<String> _confIgnoreList;
    private Set<String> _batchConfIgnoreList;
    private volatile byte bitmap$0;

    public boolean org$apache$kyuubi$session$SessionManager$$shutdown() {
        return this.org$apache$kyuubi$session$SessionManager$$shutdown;
    }

    private void org$apache$kyuubi$session$SessionManager$$shutdown_$eq(boolean x$1) {
        this.org$apache$kyuubi$session$SessionManager$$shutdown = x$1;
    }

    public Option<String> _operationLogRoot() {
        return this._operationLogRoot;
    }

    public void _operationLogRoot_$eq(Option<String> x$1) {
        this._operationLogRoot = x$1;
    }

    public Option<String> operationLogRoot() {
        return this._operationLogRoot();
    }

    private void initOperationLogRootDir() {
        try {
            String logRoot = this.isServer() ? this.conf().get(KyuubiConf$.MODULE$.SERVER_OPERATION_LOG_DIR_ROOT()) : this.conf().get(KyuubiConf$.MODULE$.ENGINE_OPERATION_LOG_DIR_ROOT());
            Path logPath = Files.createDirectories(Utils$.MODULE$.getAbsolutePathFromWork(logRoot, Utils$.MODULE$.getAbsolutePathFromWork$default$2()), new FileAttribute[0]);
            this._operationLogRoot_$eq((Option<String>)new Some((Object)((Object)logPath).toString()));
        }
        catch (IOException e) {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Failed to initialize operation log root directory: ").append(this._operationLogRoot()).toString(), e);
            this._operationLogRoot_$eq((Option<String>)None$.MODULE$);
        }
    }

    private long _latestLogoutTime() {
        return this._latestLogoutTime;
    }

    private void _latestLogoutTime_$eq(long x$1) {
        this._latestLogoutTime = x$1;
    }

    public long latestLogoutTime() {
        return this._latestLogoutTime();
    }

    public ConcurrentHashMap<SessionHandle, Session> org$apache$kyuubi$session$SessionManager$$handleToSession() {
        return this.org$apache$kyuubi$session$SessionManager$$handleToSession;
    }

    private ScheduledExecutorService timeoutChecker() {
        return this.timeoutChecker;
    }

    public abstract boolean isServer();

    private ThreadPoolExecutor execPool() {
        return this.execPool;
    }

    private void execPool_$eq(ThreadPoolExecutor x$1) {
        this.execPool = x$1;
    }

    public Future<?> submitBackgroundOperation(Runnable r) {
        return this.execPool().submit(r);
    }

    public abstract OperationManager operationManager();

    public abstract Session createSession(TProtocolVersion var1, String var2, String var3, String var4, Map<String, String> var5);

    public void logSessionCountInfo(Session session, String action) {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append(session.user()).append("'s ").append(session.getClass().getSimpleName()).append(" with").append(" ").append(session.handle()).append(session.name().map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append("/").append((String)x$1).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(" is ").append(action).append(",").append(" current opening sessions ").append(this.getOpenSessionCount()).toString());
    }

    public SessionHandle openSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        SessionHandle sessionHandle;
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Opening session for ").append(user).append("@").append(ipAddress).toString());
        Session session = this.createSession(protocol, user, password, ipAddress, conf);
        try {
            SessionHandle handle = session.handle();
            session.open();
            this.setSession(handle, session);
            this.logSessionCountInfo(session, "opened");
            sessionHandle = handle;
        }
        catch (Exception e) {
            try {
                session.close();
            }
            catch (Throwable t) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error closing session for ").append(user).append(" client ip: ").append(ipAddress).toString(), t);
            }
            throw KyuubiSQLException$.MODULE$.apply(e);
        }
        return sessionHandle;
    }

    public void closeSession(SessionHandle sessionHandle) {
        this._latestLogoutTime_$eq(System.currentTimeMillis());
        Session session = this.org$apache$kyuubi$session$SessionManager$$handleToSession().remove(sessionHandle);
        if (session == null) {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(8).append("Invalid ").append(sessionHandle).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        this.logSessionCountInfo(session, "closed");
        try {
            session.close();
        }
        finally {
            this.deleteOperationLogSessionDir(sessionHandle);
        }
    }

    private void deleteOperationLogSessionDir(SessionHandle sessionHandle) {
        this._operationLogRoot().foreach((Function1 & Serializable & scala.Serializable)logRoot -> {
            Boolean bl;
            Path rootPath = Paths.get(logRoot, sessionHandle.identifier().toString());
            try {
                bl = BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.deleteDirectoryRecursively(rootPath.toFile()));
            }
            catch (IOException e) {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Failed to delete session operation log directory ").append(((Object)rootPath).toString()).toString(), e);
                bl = BoxedUnit.UNIT;
            }
            return bl;
        });
    }

    public Option<Session> getSessionOption(SessionHandle sessionHandle) {
        return Option$.MODULE$.apply((Object)this.org$apache$kyuubi$session$SessionManager$$handleToSession().get(sessionHandle));
    }

    public Session getSession(SessionHandle sessionHandle) {
        return (Session)this.getSessionOption(sessionHandle).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(8).append("Invalid ").append(sessionHandle).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        });
    }

    public final void setSession(SessionHandle sessionHandle, Session session) {
        this.org$apache$kyuubi$session$SessionManager$$handleToSession().put(sessionHandle, session);
    }

    public int getOpenSessionCount() {
        return this.org$apache$kyuubi$session$SessionManager$$handleToSession().size();
    }

    public Iterable<Session> allSessions() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.org$apache$kyuubi$session$SessionManager$$handleToSession().values()).asScala();
    }

    public int getExecPoolSize() {
        Predef$.MODULE$.assert(this.execPool() != null);
        return this.execPool().getPoolSize();
    }

    public int getActiveCount() {
        Predef$.MODULE$.assert(this.execPool() != null);
        return this.execPool().getActiveCount();
    }

    public int getWorkQueueSize() {
        Predef$.MODULE$.assert(this.execPool() != null);
        return this.execPool().getQueue().size();
    }

    private Set<String> _confRestrictList() {
        return this._confRestrictList;
    }

    private void _confRestrictList_$eq(Set<String> x$1) {
        this._confRestrictList = x$1;
    }

    private Set<String> _confIgnoreList() {
        return this._confIgnoreList;
    }

    private void _confIgnoreList_$eq(Set<String> x$1) {
        this._confIgnoreList = x$1;
    }

    private Set<String> _batchConfIgnoreList() {
        return this._batchConfIgnoreList;
    }

    private void _batchConfIgnoreList_$eq(Set<String> x$1) {
        this._batchConfIgnoreList = x$1;
    }

    private Set<String> _confRestrictMatchList$lzycompute() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this._confRestrictMatchList = (Set)((SetLike)this._confRestrictList().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.endsWith(".*")))).map((Function1 & Serializable & scala.Serializable)x$3 -> new StringOps(Predef$.MODULE$.augmentString(x$3)).stripSuffix(".*"), Set$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._confRestrictMatchList;
    }

    private Set<String> _confRestrictMatchList() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this._confRestrictMatchList$lzycompute();
        }
        return this._confRestrictMatchList;
    }

    private Set<String> _confIgnoreMatchList$lzycompute() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this._confIgnoreMatchList = (Set)((SetLike)this._confIgnoreList().filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.endsWith(".*")))).map((Function1 & Serializable & scala.Serializable)x$5 -> new StringOps(Predef$.MODULE$.augmentString(x$5)).stripSuffix(".*"), Set$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this._confIgnoreMatchList;
    }

    private Set<String> _confIgnoreMatchList() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this._confIgnoreMatchList$lzycompute();
        }
        return this._confIgnoreMatchList;
    }

    private Set<String> _batchConfIgnoreMatchList$lzycompute() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this._batchConfIgnoreMatchList = (Set)((SetLike)this._batchConfIgnoreList().filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.endsWith(".*")))).map((Function1 & Serializable & scala.Serializable)x$7 -> new StringOps(Predef$.MODULE$.augmentString(x$7)).stripSuffix(".*"), Set$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this._batchConfIgnoreMatchList;
    }

    private Set<String> _batchConfIgnoreMatchList() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this._batchConfIgnoreMatchList$lzycompute();
        }
        return this._batchConfIgnoreMatchList;
    }

    public Option<Tuple2<String, String>> validateKey(String key, String value) {
        String normalizedKey;
        String string;
        if (key.startsWith(package$.MODULE$.SET_PREFIX())) {
            String newKey = key.substring(package$.MODULE$.SET_PREFIX().length());
            if (newKey.startsWith(package$.MODULE$.ENV_PREFIX())) {
                throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(46).append(key).append(" is forbidden, env:* variables can not be set.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }
            string = newKey.startsWith(package$.MODULE$.SYSTEM_PREFIX()) ? newKey.substring(package$.MODULE$.SYSTEM_PREFIX().length()) : (newKey.startsWith(package$.MODULE$.HIVECONF_PREFIX()) ? newKey.substring(package$.MODULE$.HIVECONF_PREFIX().length()) : (newKey.startsWith(package$.MODULE$.HIVEVAR_PREFIX()) ? newKey.substring(package$.MODULE$.HIVEVAR_PREFIX().length()) : (newKey.startsWith(package$.MODULE$.METACONF_PREFIX()) ? newKey.substring(package$.MODULE$.METACONF_PREFIX().length()) : newKey)));
        } else {
            string = normalizedKey = key;
        }
        if (this._confRestrictMatchList().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)normalizedKey.startsWith(x$1))) || this._confRestrictList().contains((Object)normalizedKey)) {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(112).append(normalizedKey).append(" is a restrict key according to the server-side").append(" configuration, please remove it and retry if you want to proceed").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        if (this._confIgnoreMatchList().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)normalizedKey.startsWith(x$1))) || this._confIgnoreList().contains((Object)normalizedKey)) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append(normalizedKey).append(" is a ignored key according to the server-side configuration").toString());
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)normalizedKey, (Object)value));
    }

    public Map<String, String> validateAndNormalizeConf(Map<String, String> config) {
        return (Map)config.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Option$.MODULE$.option2Iterable(this.validateKey(k, v));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    public Option<Tuple2<String, String>> validateBatchKey(String key, String value) {
        if (this._batchConfIgnoreMatchList().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)key.startsWith(x$1))) || this._batchConfIgnoreList().contains((Object)key)) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append(key).append(" is a ignored batch key according to the server-side configuration").toString());
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)key, (Object)value));
    }

    public Map<String, String> validateBatchConf(Map<String, String> config) {
        return (Map)config.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Option$.MODULE$.option2Iterable(this.validateBatchKey(k, v));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    @Override
    public synchronized void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        this.addService(this.operationManager());
        this.initOperationLogRootDir();
        int poolSize = this.isServer() ? BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.SERVER_EXEC_POOL_SIZE())) : BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_EXEC_POOL_SIZE()));
        int waitQueueSize = this.isServer() ? BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.SERVER_EXEC_WAIT_QUEUE_SIZE())) : BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_EXEC_WAIT_QUEUE_SIZE()));
        long keepAliveMs = this.isServer() ? BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.SERVER_EXEC_KEEPALIVE_TIME())) : BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_EXEC_KEEPALIVE_TIME()));
        this._confRestrictList_$eq(conf.get(KyuubiConf$.MODULE$.SESSION_CONF_RESTRICT_LIST()));
        this._confIgnoreList_$eq((Set<String>)((Set)((SetLike)conf.get(KyuubiConf$.MODULE$.SESSION_CONF_IGNORE_LIST())).$plus((Object)String.valueOf(KyuubiConf$.MODULE$.SESSION_USER_SIGN_ENABLED().key()))));
        this._batchConfIgnoreList_$eq(conf.get(KyuubiConf$.MODULE$.BATCH_CONF_IGNORE_LIST()));
        this.execPool_$eq(ThreadUtils$.MODULE$.newDaemonQueuedThreadPool(poolSize, waitQueueSize, keepAliveMs, new StringBuilder(10).append(this.name).append("-exec-pool").toString()));
        super.initialize(conf);
    }

    @Override
    public synchronized void start() {
        this.startTimeoutChecker();
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
        this.org$apache$kyuubi$session$SessionManager$$shutdown_$eq(true);
        long shutdownTimeout = this.isServer() ? BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.SERVER_EXEC_POOL_SHUTDOWN_TIMEOUT())) : BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_EXEC_POOL_SHUTDOWN_TIMEOUT()));
        ThreadUtils$.MODULE$.shutdown(this.timeoutChecker(), (Duration)Duration$.MODULE$.apply(shutdownTimeout, TimeUnit.MILLISECONDS));
        ThreadUtils$.MODULE$.shutdown(this.execPool(), (Duration)Duration$.MODULE$.apply(shutdownTimeout, TimeUnit.MILLISECONDS));
    }

    private void startTimeoutChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.SESSION_CHECK_INTERVAL()));
        Runnable checkTask = new Runnable(this){
            private final /* synthetic */ SessionManager $outer;

            public void run() {
                this.$outer.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Checking sessions timeout, current count: ").append($this.$outer.getOpenSessionCount()).toString());
                long current = System.currentTimeMillis();
                if (!this.$outer.org$apache$kyuubi$session$SessionManager$$shutdown()) {
                    ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.$outer.org$apache$kyuubi$session$SessionManager$$handleToSession().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)session -> {
                        $anon$1.$anonfun$run$2(this, current, session);
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
            }

            public static final /* synthetic */ void $anonfun$run$2($anon$1 $this, long current$1, Session session) {
                try {
                    if (session.lastAccessTime() + session.sessionIdleTimeoutThreshold() <= current$1 && session.getNoOperationTime() > session.sessionIdleTimeoutThreshold()) {
                        $this.$outer.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Closing session ").append(session.handle().identifier()).append(" that has been idle for more").append(" than ").append(session.sessionIdleTimeoutThreshold()).append(" ms").toString());
                        $this.$outer.closeSession(session.handle());
                    } else {
                        session.closeExpiredOperations();
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        $this.$outer.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Error checking session ").append(session.handle()).append(" timeout").toString(), e);
                    }
                    throw throwable;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.kyuubi.session.SessionManager$$anon$1 ), $anonfun$run$2$adapted(org.apache.kyuubi.session.SessionManager$$anon$1 long org.apache.kyuubi.session.Session ), $anonfun$run$3(org.apache.kyuubi.session.Session ), $anonfun$run$4(org.apache.kyuubi.session.Session )}, serializedLambda);
            }
        };
        ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(this.timeoutChecker(), checkTask, interval, interval, TimeUnit.MILLISECONDS);
    }

    public void startTerminatingChecker(Function0<BoxedUnit> stop) {
        if (!this.isServer()) {
            this._latestLogoutTime_$eq(System.currentTimeMillis());
            long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_CHECK_INTERVAL()));
            long idleTimeout = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_IDLE_TIMEOUT()));
            if (idleTimeout > 0L) {
                Runnable checkTask = new Runnable(this, idleTimeout, stop){
                    private final /* synthetic */ SessionManager $outer;
                    private final long idleTimeout$1;
                    private final Function0 stop$1;

                    public void run() {
                        if (!this.$outer.org$apache$kyuubi$session$SessionManager$$shutdown() && System.currentTimeMillis() - this.$outer.latestLogoutTime() > this.idleTimeout$1 && this.$outer.getOpenSessionCount() <= 0) {
                            this.$outer.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Idled for more than ").append($this.idleTimeout$1).append(" ms, terminating").toString());
                            this.stop$1.apply$mcV$sp();
                            return;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.idleTimeout$1 = idleTimeout$1;
                        this.stop$1 = stop$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$5(org.apache.kyuubi.session.SessionManager$$anon$2 )}, serializedLambda);
                    }
                };
                ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(this.timeoutChecker(), checkTask, interval, interval, TimeUnit.MILLISECONDS);
                return;
            }
            return;
        }
    }

    public SessionManager(String name) {
        this.name = name;
        super(name);
        this.org$apache$kyuubi$session$SessionManager$$shutdown = false;
        this._operationLogRoot = None$.MODULE$;
        this._latestLogoutTime = System.currentTimeMillis();
        this.org$apache$kyuubi$session$SessionManager$$handleToSession = new ConcurrentHashMap();
        this.timeoutChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor(new StringBuilder(16).append(name).append("-timeout-checker").toString(), ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
    }
}

