/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Duration;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.AbstractManifestData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.FileEntry;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.util.JsonSerialization;

@InterfaceAudience.LimitedPrivate(value={"mapreduce, object-stores"})
@InterfaceStability.Unstable
public abstract class ManifestStoreOperations
implements Closeable {
    public void bindToFileSystem(FileSystem fileSystem, Path path) throws IOException {
    }

    public abstract FileStatus getFileStatus(Path var1) throws IOException;

    public boolean isFile(Path path) throws IOException {
        try {
            return this.getFileStatus(path).isFile();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public abstract boolean delete(Path var1, boolean var2) throws IOException;

    public abstract boolean mkdirs(Path var1) throws IOException;

    public abstract boolean renameFile(Path var1, Path var2) throws IOException;

    public boolean renameDir(Path source, Path dest) throws IOException {
        return this.renameFile(source, dest);
    }

    public abstract RemoteIterator<FileStatus> listStatusIterator(Path var1) throws IOException;

    public abstract TaskManifest loadTaskManifest(JsonSerialization<TaskManifest> var1, FileStatus var2) throws IOException;

    public abstract <T extends AbstractManifestData<T>> void save(T var1, Path var2, boolean var3) throws IOException;

    public void msync(Path path) throws IOException {
    }

    public String getEtag(FileStatus status) {
        return ManifestCommitterSupport.getEtag(status);
    }

    public boolean storePreservesEtagsThroughRenames(Path path) {
        return false;
    }

    public boolean storeSupportsResilientCommit() {
        return false;
    }

    public CommitFileResult commitFile(FileEntry entry) throws IOException {
        throw new UnsupportedOperationException("Resilient commit not supported");
    }

    public static final class CommitFileResult {
        private final boolean recovered;
        @Nullable
        private final Duration waitTime;

        public static CommitFileResult fromResilientCommit(boolean recovered, Duration waitTime) {
            return new CommitFileResult(recovered, waitTime);
        }

        public CommitFileResult(boolean recovered, @Nullable Duration waitTime) {
            this.recovered = recovered;
            this.waitTime = waitTime;
        }

        public boolean recovered() {
            return this.recovered;
        }

        @Nullable
        public Duration getWaitTime() {
            return this.waitTime;
        }
    }
}

