/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.auth;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kyuubi.jdbc.hive.auth.CachingKerberosAuthentication;
import org.apache.kyuubi.jdbc.hive.auth.KerberosAuthentication;

public class KerberosAuthenticationManager {
    private static CachingKerberosAuthentication GLOBAL_TGT_CACHE_AUTHENTICATION;
    private static final Map<String, CachingKerberosAuthentication> KEYTAB_AUTHENTICATION_CACHE;

    public static synchronized CachingKerberosAuthentication getTgtCacheAuthentication(String ticketCache) {
        if (GLOBAL_TGT_CACHE_AUTHENTICATION == null) {
            KerberosAuthentication tgtCacheAuth = new KerberosAuthentication(ticketCache);
            GLOBAL_TGT_CACHE_AUTHENTICATION = new CachingKerberosAuthentication(tgtCacheAuth);
        }
        return GLOBAL_TGT_CACHE_AUTHENTICATION;
    }

    public static CachingKerberosAuthentication getKeytabAuthentication(String principal, String keytab) {
        return KEYTAB_AUTHENTICATION_CACHE.computeIfAbsent(principal + ":" + keytab, key -> {
            KerberosAuthentication keytabAuth = new KerberosAuthentication(principal, keytab);
            return new CachingKerberosAuthentication(keytabAuth);
        });
    }

    static {
        KEYTAB_AUTHENTICATION_CACHE = new ConcurrentHashMap<String, CachingKerberosAuthentication>();
    }
}

