/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.curator;

import java.io.Closeable;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kyuubi.shade.org.apache.curator.CuratorConnectionLossException;
import org.apache.kyuubi.shade.org.apache.curator.HandleHolder;
import org.apache.kyuubi.shade.org.apache.curator.SessionFailRetryLoop;
import org.apache.kyuubi.shade.org.apache.curator.drivers.EventTrace;
import org.apache.kyuubi.shade.org.apache.curator.drivers.OperationTrace;
import org.apache.kyuubi.shade.org.apache.curator.drivers.TracerDriver;
import org.apache.kyuubi.shade.org.apache.curator.ensemble.EnsembleProvider;
import org.apache.kyuubi.shade.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kyuubi.shade.org.apache.curator.utils.CloseableUtils;
import org.apache.kyuubi.shade.org.apache.curator.utils.ThreadUtils;
import org.apache.kyuubi.shade.org.apache.curator.utils.ZookeeperFactory;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionState
implements Watcher,
Closeable {
    private static final int MAX_BACKGROUND_EXCEPTIONS = 10;
    private static final boolean LOG_EVENTS = Boolean.getBoolean("curator-log-events");
    private static final Logger log = LoggerFactory.getLogger(ConnectionState.class);
    private final HandleHolder zooKeeper;
    private final AtomicBoolean isConnected = new AtomicBoolean(false);
    private final EnsembleProvider ensembleProvider;
    private final int sessionTimeoutMs;
    private final int connectionTimeoutMs;
    private final AtomicReference<TracerDriver> tracer;
    private final Queue<Exception> backgroundExceptions = new ConcurrentLinkedQueue<Exception>();
    private final Queue<Watcher> parentWatchers = new ConcurrentLinkedQueue<Watcher>();
    private final AtomicLong instanceIndex = new AtomicLong();
    private volatile long connectionStartMs = 0L;
    @VisibleForTesting
    volatile boolean debugWaitOnExpiredEvent = false;

    ConnectionState(ZookeeperFactory zookeeperFactory, EnsembleProvider ensembleProvider, int sessionTimeoutMs, int connectionTimeoutMs, Watcher parentWatcher, AtomicReference<TracerDriver> tracer, boolean canBeReadOnly) {
        this.ensembleProvider = ensembleProvider;
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.tracer = tracer;
        if (parentWatcher != null) {
            this.parentWatchers.offer(parentWatcher);
        }
        this.zooKeeper = new HandleHolder(zookeeperFactory, this, ensembleProvider, sessionTimeoutMs, canBeReadOnly);
    }

    ZooKeeper getZooKeeper() throws Exception {
        if (SessionFailRetryLoop.sessionForThreadHasFailed()) {
            throw new SessionFailRetryLoop.SessionFailedException();
        }
        Exception exception = this.backgroundExceptions.poll();
        if (exception != null) {
            new EventTrace("background-exceptions", this.tracer.get()).commit();
            throw exception;
        }
        boolean localIsConnected = this.isConnected.get();
        if (!localIsConnected) {
            this.checkTimeouts();
        }
        return this.zooKeeper.getZooKeeper();
    }

    boolean isConnected() {
        return this.isConnected.get();
    }

    void start() throws Exception {
        log.debug("Starting");
        this.ensembleProvider.start();
        this.reset();
    }

    @Override
    public void close() throws IOException {
        log.debug("Closing");
        CloseableUtils.closeQuietly(this.ensembleProvider);
        try {
            this.zooKeeper.closeAndClear();
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted(e);
            throw new IOException(e);
        }
        finally {
            this.isConnected.set(false);
        }
    }

    void addParentWatcher(Watcher watcher) {
        this.parentWatchers.offer(watcher);
    }

    void removeParentWatcher(Watcher watcher) {
        this.parentWatchers.remove(watcher);
    }

    long getInstanceIndex() {
        return this.instanceIndex.get();
    }

    public void process(WatchedEvent event) {
        boolean eventTypeNone;
        if (LOG_EVENTS) {
            log.debug("ConnectState watcher: " + event);
        }
        boolean bl = eventTypeNone = event.getType() == Watcher.Event.EventType.None;
        if (eventTypeNone) {
            boolean wasConnected = this.isConnected.get();
            boolean newIsConnected = this.checkState(event.getState(), wasConnected);
            if (newIsConnected != wasConnected) {
                this.isConnected.set(newIsConnected);
                this.connectionStartMs = System.currentTimeMillis();
            }
        }
        if (this.debugWaitOnExpiredEvent && event.getState() == Watcher.Event.KeeperState.Expired) {
            this.waitOnExpiredEvent();
        }
        for (Watcher parentWatcher : this.parentWatchers) {
            OperationTrace trace = new OperationTrace("connection-state-parent-process", this.tracer.get(), this.getSessionId());
            parentWatcher.process(event);
            trace.commit();
        }
        if (eventTypeNone) {
            this.handleState(event.getState());
        }
    }

    private void waitOnExpiredEvent() {
        log.debug("Waiting on Expired event for testing");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.debug("Continue processing");
    }

    EnsembleProvider getEnsembleProvider() {
        return this.ensembleProvider;
    }

    private synchronized void checkTimeouts() throws Exception {
        int minTimeout = Math.min(this.sessionTimeoutMs, this.connectionTimeoutMs);
        long elapsed = System.currentTimeMillis() - this.connectionStartMs;
        if (elapsed >= (long)minTimeout) {
            if (this.zooKeeper.hasNewConnectionString()) {
                this.handleNewConnectionString();
            } else {
                int maxTimeout = Math.max(this.sessionTimeoutMs, this.connectionTimeoutMs);
                if (elapsed > (long)maxTimeout) {
                    if (!Boolean.getBoolean("curator-dont-log-connection-problems")) {
                        log.warn(String.format("Connection attempt unsuccessful after %d (greater than max timeout of %d). Resetting connection and trying again with a new connection.", elapsed, maxTimeout));
                    }
                    this.reset();
                } else {
                    CuratorConnectionLossException connectionLossException = new CuratorConnectionLossException();
                    if (!Boolean.getBoolean("curator-dont-log-connection-problems")) {
                        log.error(String.format("Connection timed out for connection string (%s) and timeout (%d) / elapsed (%d)", this.zooKeeper.getConnectionString(), this.connectionTimeoutMs, elapsed), (Throwable)((Object)connectionLossException));
                    }
                    new EventTrace("connections-timed-out", this.tracer.get(), this.getSessionId()).commit();
                    throw connectionLossException;
                }
            }
        }
    }

    public long getSessionId() {
        long sessionId = 0L;
        try {
            ZooKeeper zk = this.zooKeeper.getZooKeeper();
            if (zk != null) {
                sessionId = zk.getSessionId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sessionId;
    }

    private synchronized void reset() throws Exception {
        log.debug("reset");
        this.instanceIndex.incrementAndGet();
        this.isConnected.set(false);
        this.connectionStartMs = System.currentTimeMillis();
        this.zooKeeper.closeAndReset();
        this.zooKeeper.getZooKeeper();
    }

    private boolean checkState(Watcher.Event.KeeperState state, boolean wasConnected) {
        boolean isConnected = wasConnected;
        switch (state) {
            default: {
                isConnected = false;
                break;
            }
            case SyncConnected: 
            case ConnectedReadOnly: {
                isConnected = true;
                break;
            }
            case AuthFailed: {
                isConnected = false;
                log.error("Authentication failed");
            }
            case SaslAuthenticated: 
        }
        if (state != Watcher.Event.KeeperState.Expired) {
            new EventTrace(state.toString(), this.tracer.get(), this.getSessionId()).commit();
        }
        return isConnected;
    }

    private void handleState(Watcher.Event.KeeperState state) {
        if (state == Watcher.Event.KeeperState.Expired) {
            this.handleExpiredSession();
        } else if (this.zooKeeper.hasNewConnectionString()) {
            this.handleNewConnectionString();
        }
    }

    private void handleNewConnectionString() {
        log.info("Connection string changed");
        new EventTrace("connection-string-changed", this.tracer.get(), this.getSessionId()).commit();
        try {
            this.reset();
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted(e);
            this.queueBackgroundException(e);
        }
    }

    private void handleExpiredSession() {
        log.warn("Session expired event received");
        new EventTrace("session-expired", this.tracer.get(), this.getSessionId()).commit();
        try {
            this.reset();
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted(e);
            this.queueBackgroundException(e);
        }
    }

    private void queueBackgroundException(Exception e) {
        while (this.backgroundExceptions.size() >= 10) {
            this.backgroundExceptions.poll();
        }
        this.backgroundExceptions.offer(e);
    }
}

