/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ha.client.zookeeper;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import javax.security.auth.login.Configuration;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.retry.RetryOneTime;
import org.apache.curator.retry.RetryUntilElapsed;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.AuthTypes$;
import org.apache.kyuubi.ha.client.RetryPolicies$;
import org.apache.kyuubi.ha.client.zookeeper.ZookeeperACLProvider;
import org.apache.kyuubi.reflection.DynConstructors;
import org.apache.kyuubi.util.KyuubiHadoopUtils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class ZookeeperClientProvider$
implements Logging {
    public static ZookeeperClientProvider$ MODULE$;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new ZookeeperClientProvider$();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public CuratorFramework buildZookeeperClient(KyuubiConf conf) {
        Object object;
        this.setUpZooKeeperAuth(conf);
        String connectionStr = (String)conf.get(HighAvailabilityConf$.MODULE$.HA_ADDRESSES());
        int sessionTimeout = BoxesRunTime.unboxToInt((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_SESSION_TIMEOUT()));
        int connectionTimeout = BoxesRunTime.unboxToInt((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_TIMEOUT()));
        int baseSleepTime = BoxesRunTime.unboxToInt((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_BASE_RETRY_WAIT()));
        int maxSleepTime = BoxesRunTime.unboxToInt((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_MAX_RETRY_WAIT()));
        int maxRetries = BoxesRunTime.unboxToInt((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_MAX_RETRIES()));
        String retryPolicyName = (String)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_RETRY_POLICY());
        Enumeration.Value value = RetryPolicies$.MODULE$.withName(retryPolicyName);
        Enumeration.Value value2 = RetryPolicies$.MODULE$.ONE_TIME();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            object = new RetryOneTime(baseSleepTime);
        } else {
            Enumeration.Value value4 = RetryPolicies$.MODULE$.N_TIME();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                object = new RetryNTimes(maxRetries, baseSleepTime);
            } else {
                Enumeration.Value value6 = RetryPolicies$.MODULE$.BOUNDED_EXPONENTIAL_BACKOFF();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    object = new BoundedExponentialBackoffRetry(baseSleepTime, maxSleepTime, maxRetries);
                } else {
                    Enumeration.Value value8 = RetryPolicies$.MODULE$.UNTIL_ELAPSED();
                    Enumeration.Value value9 = value;
                    object = !(value8 != null ? !value8.equals(value9) : value9 != null) ? new RetryUntilElapsed(maxSleepTime, baseSleepTime) : new ExponentialBackoffRetry(baseSleepTime, maxRetries);
                }
            }
        }
        RetryOneTime retryPolicy = object;
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString(connectionStr).sessionTimeoutMs(sessionTimeout).connectionTimeoutMs(connectionTimeout).aclProvider((ACLProvider)new ZookeeperACLProvider(conf)).retryPolicy((RetryPolicy)retryPolicy);
        ((Option)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_AUTH_DIGEST())).foreach((Function1 & Serializable & scala.Serializable)authString -> builder.authorization("digest", authString.getBytes(StandardCharsets.UTF_8)));
        return builder.build();
    }

    public long getGracefulStopThreadDelay(KyuubiConf conf) {
        int baseSleepTime = BoxesRunTime.unboxToInt((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_BASE_RETRY_WAIT()));
        int maxSleepTime = BoxesRunTime.unboxToInt((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_MAX_RETRY_WAIT()));
        int maxRetries = BoxesRunTime.unboxToInt((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_MAX_RETRIES()));
        String retryPolicyName = (String)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_RETRY_POLICY());
        Enumeration.Value value = RetryPolicies$.MODULE$.withName(retryPolicyName);
        Enumeration.Value value2 = RetryPolicies$.MODULE$.ONE_TIME();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return baseSleepTime;
        }
        Enumeration.Value value4 = RetryPolicies$.MODULE$.N_TIME();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return maxRetries * baseSleepTime;
        }
        Enumeration.Value value6 = RetryPolicies$.MODULE$.BOUNDED_EXPONENTIAL_BACKOFF();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            return BoxesRunTime.unboxToInt((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), maxRetries).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)retryCount -> {
                int retryWait = baseSleepTime * Math.max(1, Random$.MODULE$.nextInt(1 << retryCount + 1));
                return Math.min(retryWait, maxSleepTime);
            }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
        Enumeration.Value value8 = RetryPolicies$.MODULE$.UNTIL_ELAPSED();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            return maxSleepTime;
        }
        Enumeration.Value value10 = RetryPolicies$.MODULE$.EXPONENTIAL_BACKOFF();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            return BoxesRunTime.unboxToInt((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), maxRetries).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)retryCount -> baseSleepTime * Math.max(1, Random$.MODULE$.nextInt(1 << retryCount + 1)), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
        throw new MatchError((Object)value);
    }

    public void setUpZooKeeperAuth(KyuubiConf conf) throws Exception {
        if (((Option)conf.get(HighAvailabilityConf$.MODULE$.HA_ENGINE_REF_ID())).isEmpty()) {
            Enumeration.Value value = AuthTypes$.MODULE$.withName((String)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_AUTH_TYPE()));
            Enumeration.Value value2 = AuthTypes$.MODULE$.KERBEROS();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                this.setupZkAuth$1(conf);
                return;
            }
        }
        if (((Option)conf.get(HighAvailabilityConf$.MODULE$.HA_ENGINE_REF_ID())).nonEmpty()) {
            Enumeration.Value value = AuthTypes$.MODULE$.withName((String)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_ENGINE_AUTH_TYPE()));
            Enumeration.Value value3 = AuthTypes$.MODULE$.KERBEROS();
            if (!(value != null ? !value.equals(value3) : value3 != null)) {
                this.setupZkAuth$1(conf);
                return;
            }
        }
    }

    @VisibleForTesting
    public Option<String> getKeyTabFile(KyuubiConf conf) {
        return ((Option)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_AUTH_KEYTAB())).map((Function1 & Serializable & scala.Serializable)fullPath -> {
            String filename = new File((String)fullPath).getName();
            if (new File(filename).exists()) {
                return filename;
            }
            return fullPath;
        });
    }

    private final void setupZkAuth$1(KyuubiConf conf$1) {
        Tuple2 tuple2 = new Tuple2(conf$1.get(HighAvailabilityConf$.MODULE$.HA_ZK_AUTH_PRINCIPAL()), this.getKeyTabFile(conf$1));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String principal = (String)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    String keytab = (String)some2.value();
                    if (UserGroupInformation.isSecurityEnabled()) {
                        if (!new File(keytab).exists()) {
                            throw new IOException(new StringBuilder(18).append(HighAvailabilityConf$.MODULE$.HA_ZK_AUTH_KEYTAB().key()).append(": ").append(keytab).append(" does not exists").toString());
                        }
                        System.setProperty("zookeeper.sasl.clientconfig", "KyuubiZooKeeperClient");
                        String serverPrincipal = KyuubiHadoopUtils$.MODULE$.getServerPrincipal(principal);
                        Configuration jaasConf = (Configuration)DynConstructors.builder().impl("org.apache.hadoop.security.authentication.util.JaasConfiguration", new Class[]{String.class, String.class, String.class}).impl("org.apache.hadoop.security.token.delegation.ZKDelegationTokenSecretManager$JaasConfiguration", new Class[]{String.class, String.class, String.class}).build().newInstance(new Object[]{"KyuubiZooKeeperClient", serverPrincipal, keytab});
                        Configuration.setConfiguration(jaasConf);
                        return;
                    }
                }
            }
        }
    }

    private ZookeeperClientProvider$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

