/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client;

import java.util.Optional;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.impl.PathCapabilitiesSupport;

public final class DfsPathCapabilities {
    private DfsPathCapabilities() {
    }

    public static Optional<Boolean> hasPathCapability(Path path, String capability) {
        switch (PathCapabilitiesSupport.validatePathCapabilityArgs(path, capability)) {
            case "fs.capability.paths.acls": 
            case "fs.capability.paths.append": 
            case "fs.capability.paths.checksums": 
            case "fs.capability.paths.concat": 
            case "fs.capability.paths.list-corrupt-file-blocks": 
            case "fs.capability.multipart.uploader": 
            case "fs.capability.paths.pathhandles": 
            case "fs.capability.paths.permissions": 
            case "fs.capability.paths.snapshots": 
            case "fs.capability.paths.storagepolicy": 
            case "fs.capability.paths.xattrs": {
                return Optional.of(true);
            }
            case "fs.capability.paths.symlinks": {
                return Optional.of(FileSystem.areSymlinksEnabled());
            }
        }
        return Optional.empty();
    }
}

