/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.kyuubi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.kyuubi.engine.spark.operation.progress.SparkOperationProgressStatus$;
import org.apache.kyuubi.engine.spark.operation.progress.SparkStage;
import org.apache.kyuubi.engine.spark.operation.progress.SparkStageProgress;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TJobExecutionStatus;
import org.apache.spark.kyuubi.SparkProgressMonitor$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.StageStatus;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.SortedMap$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u000b\u0017\u0001}A\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!)\u0001\b\u0001C\u0001s!9a\b\u0001b\u0001\n\u0013y\u0004B\u0002$\u0001A\u0003%\u0001\t\u0003\u0005H\u0001!\u0015\r\u0011\"\u0003I\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u0015Q\u0007\u0001\"\u0001l\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u0015i\b\u0001\"\u0003\u007f\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'9q!!\u0006\u0017\u0011\u0003\t9B\u0002\u0004\u0016-!\u0005\u0011\u0011\u0004\u0005\u0007q=!\t!a\u0007\t\u0011\u0005uqB1A\u0005\nqCq!a\b\u0010A\u0003%Q\fC\u0005\u0002\"=\u0011\r\u0011\"\u0003\u0002\u0014!A\u00111E\b!\u0002\u0013\t9A\u0001\u000bTa\u0006\u00148\u000e\u0015:pOJ,7o]'p]&$xN\u001d\u0006\u0003/a\taa[=vk\nL'BA\r\u001b\u0003\u0015\u0019\b/\u0019:l\u0015\tYB$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%B\u0012aA:rY&\u00111\u0006\u000b\u0002\r'B\f'o[*fgNLwN\\\u0001\tU>\u0014wI]8vaB\u0011a&\u000e\b\u0003_M\u0002\"\u0001\r\u0012\u000e\u0003ER!A\r\u0010\u0002\rq\u0012xn\u001c;?\u0013\t!$%\u0001\u0004Qe\u0016$WMZ\u0005\u0003m]\u0012aa\u0015;sS:<'B\u0001\u001b#\u0003\u0019a\u0014N\\5u}Q\u0019!\bP\u001f\u0011\u0005m\u0002Q\"\u0001\f\t\u000be\u0019\u0001\u0019\u0001\u0014\t\u000b1\u001a\u0001\u0019A\u0017\u0002\u0017M$\u0018\r^;t'R|'/Z\u000b\u0002\u0001B\u0011\u0011\tR\u0007\u0002\u0005*\u00111\tG\u0001\u0007gR\fG/^:\n\u0005\u0015\u0013%AD!qaN#\u0018\r^;t'R|'/Z\u0001\rgR\fG/^:Ti>\u0014X\rI\u0001\faJ|wM]3tg6\u000b\u0007/F\u0001J!\u0011q#\n\u0014-\n\u0005-;$aA'baB\u0011QJV\u0007\u0002\u001d*\u0011q\nU\u0001\taJ|wM]3tg*\u0011\u0011KU\u0001\n_B,'/\u0019;j_:T!!G*\u000b\u0005Q+\u0016AB3oO&tWM\u0003\u0002\u00185%\u0011qK\u0014\u0002\u000b'B\f'o[*uC\u001e,\u0007CA'Z\u0013\tQfJ\u0001\nTa\u0006\u00148n\u0015;bO\u0016\u0004&o\\4sKN\u001c\u0018a\u00025fC\u0012,'o]\u000b\u0002;B\u0019alY\u0017\u000e\u0003}S!\u0001Y1\u0002\tU$\u0018\u000e\u001c\u0006\u0002E\u0006!!.\u0019<b\u0013\t!wL\u0001\u0003MSN$\u0018\u0001\u0002:poN,\u0012a\u001a\t\u0004=\u000el\u0016!\u00044p_R,'oU;n[\u0006\u0014\u00180F\u0001.\u0003Q\u0001(o\\4sKN\u001cX\r\u001a)fe\u000e,g\u000e^1hKV\tA\u000e\u0005\u0002\"[&\u0011aN\t\u0002\u0007\t>,(\r\\3\u0002\u001f\u0015DXmY;uS>t7\u000b^1ukN,\u0012!\u001d\t\u0003enl\u0011a\u001d\u0006\u0003iV\fa\u0001\u001e5sS\u001a$(B\u0001<x\u0003\r\u0011\bo\u0019\u0006\u0003qf\fqa]3sm&\u001cWM\u0003\u0002{5\u0005!\u0001.\u001b<f\u0013\ta8OA\nU\u0015>\u0014W\t_3dkRLwN\\*uCR,8/A\nhKRt\u0015-\\3XSRD\u0007K]8he\u0016\u001c8\u000f\u0006\u0004.\u007f\u0006\r\u0011Q\u0002\u0005\u0007\u0003\u0003a\u0001\u0019A\u0017\u0002\u0003MDq!!\u0002\r\u0001\u0004\t9!\u0001\u0005d_6\u0004H.\u001a;f!\r\t\u0013\u0011B\u0005\u0004\u0003\u0017\u0011#aA%oi\"9\u0011q\u0002\u0007A\u0002\u0005\u001d\u0011!\u0002;pi\u0006d\u0017AE4fi\u000e{W\u000e\u001d7fi\u0016$7\u000b^1hKN,\"!a\u0002\u0002)M\u0003\u0018M]6Qe><'/Z:t\u001b>t\u0017\u000e^8s!\tYtb\u0005\u0002\u0010AQ\u0011\u0011qC\u0001\b\u0011\u0016\u000bE)\u0012*T\u0003!AU)\u0011#F%N\u0003\u0013AD\"P\u0019VkejX\u0019`/&#E\u000bS\u0001\u0010\u0007>cU+\u0014(`c};\u0016\n\u0012+IA\u0001")
public class SparkProgressMonitor {
    private Map<SparkStage, SparkStageProgress> progressMap;
    private final String jobGroup;
    private final AppStatusStore statusStore;
    private volatile boolean bitmap$0;

    private AppStatusStore statusStore() {
        return this.statusStore;
    }

    private Map<SparkStage, SparkStageProgress> progressMap$lzycompute() {
        SparkProgressMonitor sparkProgressMonitor = this;
        synchronized (sparkProgressMonitor) {
            if (!this.bitmap$0) {
                Seq stages = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)this.statusStore().jobsList(null).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SparkProgressMonitor.$anonfun$progressMap$1(this, x$1)))).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.stageIds(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)stageId -> Option$.MODULE$.option2Iterable(this.statusStore().asOption((Function0 & Serializable & scala.Serializable)() -> $this.statusStore().lastStageAttempt(stageId))), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)stage -> {
                    SparkStage sparkStage = new SparkStage(stage.stageId(), stage.attemptId());
                    StageStatus stageStatus = stage.status();
                    StageStatus stageStatus2 = StageStatus.SKIPPED;
                    int completedTasksCount = !(stageStatus != null ? !stageStatus.equals(stageStatus2) : stageStatus2 != null) ? stage.numTasks() : stage.numCompleteTasks();
                    SparkStageProgress sparkStageProgress = new SparkStageProgress(stage.numTasks(), completedTasksCount, stage.numActiveTasks(), stage.numFailedTasks());
                    return new Tuple2((Object)sparkStage, (Object)sparkStageProgress);
                }, Seq$.MODULE$.canBuildFrom());
                this.progressMap = (Map)SortedMap$.MODULE$.apply(stages, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                this.bitmap$0 = true;
            }
        }
        return this.progressMap;
    }

    private Map<SparkStage, SparkStageProgress> progressMap() {
        if (!this.bitmap$0) {
            return this.progressMap$lzycompute();
        }
        return this.progressMap;
    }

    public List<String> headers() {
        return SparkProgressMonitor$.MODULE$.org$apache$spark$kyuubi$SparkProgressMonitor$$HEADERS();
    }

    public List<List<String>> rows() {
        Collection progressRows = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableOnce)this.progressMap().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Enumeration.Value state;
                SparkStage stage = (SparkStage)tuple2._1();
                SparkStageProgress progress = (SparkStageProgress)tuple2._2();
                int complete = progress.completedTasksCount();
                int total = progress.totalTaskCount();
                int running = progress.runningTaskCount();
                int failed = progress.failedTaskCount();
                Enumeration.Value value = state = total > 0 ? SparkOperationProgressStatus$.MODULE$.PENDING() : SparkOperationProgressStatus$.MODULE$.FINISHED();
                if (complete > 0 || running > 0 || failed > 0) {
                    state = complete < total ? SparkOperationProgressStatus$.MODULE$.RUNNING() : SparkOperationProgressStatus$.MODULE$.FINISHED();
                }
                String attempt = String.valueOf(stage.attemptId());
                String stageName = new StringBuilder(6).append("Stage-").append(String.valueOf(stage.stageId())).toString();
                String nameWithProgress = this.getNameWithProgress(stageName, complete, total);
                int pending = total - complete - running;
                return Arrays.asList((Object[])new String[]{nameWithProgress, attempt, state.toString(), String.valueOf(total), String.valueOf(complete), String.valueOf(running), String.valueOf(pending), String.valueOf(failed), ""});
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toList()).asJavaCollection();
        return new ArrayList<List<String>>(progressRows);
    }

    public String footerSummary() {
        return new StringOps(Predef$.MODULE$.augmentString("STAGES: %02d/%02d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.getCompletedStages()), BoxesRunTime.boxToInteger((int)this.progressMap().keySet().size())}));
    }

    public double progressedPercentage() {
        IntRef sumTotal = IntRef.create((int)0);
        IntRef sumComplete = IntRef.create((int)0);
        this.progressMap().values().foreach((Function1 & Serializable & scala.Serializable)progress -> {
            SparkProgressMonitor.$anonfun$progressedPercentage$1(sumTotal, sumComplete, progress);
            return BoxedUnit.UNIT;
        });
        if (sumTotal.elem == 0) {
            return 1.0;
        }
        return (float)sumComplete.elem / (float)sumTotal.elem;
    }

    public TJobExecutionStatus executionStatus() {
        if (this.getCompletedStages() == this.progressMap().keySet().size()) {
            return TJobExecutionStatus.COMPLETE;
        }
        return TJobExecutionStatus.IN_PROGRESS;
    }

    private String getNameWithProgress(String s, int complete, int total) {
        if (s == null) {
            return "";
        }
        float percent = total == 0 ? 1.0f : (float)complete / (float)total;
        int spaceRemaining = SparkProgressMonitor$.MODULE$.org$apache$spark$kyuubi$SparkProgressMonitor$$COLUMN_1_WIDTH() - s.length() - 1;
        String trimmedVName = s;
        if (s.length() > SparkProgressMonitor$.MODULE$.org$apache$spark$kyuubi$SparkProgressMonitor$$COLUMN_1_WIDTH()) {
            trimmedVName = s.substring(0, SparkProgressMonitor$.MODULE$.org$apache$spark$kyuubi$SparkProgressMonitor$$COLUMN_1_WIDTH() - 2);
            trimmedVName = new StringBuilder(2).append(trimmedVName).append("..").toString();
        } else {
            trimmedVName = new StringBuilder(1).append(trimmedVName).append(" ").toString();
        }
        scala.collection.mutable.StringBuilder result = new scala.collection.mutable.StringBuilder(trimmedVName);
        int toFill = (int)((float)spaceRemaining * percent);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), toFill).foreach((Function1 & Serializable & scala.Serializable)i -> result.append("."));
        return result.toString();
    }

    private int getCompletedStages() {
        IntRef completed = IntRef.create((int)0);
        this.progressMap().values().foreach((Function1 & Serializable & scala.Serializable)progress -> {
            SparkProgressMonitor.$anonfun$getCompletedStages$1(completed, progress);
            return BoxedUnit.UNIT;
        });
        return completed.elem;
    }

    public static final /* synthetic */ boolean $anonfun$progressMap$1(SparkProgressMonitor $this, JobData x$1) {
        Option option = x$1.jobGroup();
        Option option2 = Option$.MODULE$.apply((Object)$this.jobGroup);
        return !(option != null ? !option.equals(option2) : option2 != null);
    }

    public static final /* synthetic */ void $anonfun$progressedPercentage$1(IntRef sumTotal$1, IntRef sumComplete$1, SparkStageProgress progress) {
        int complete = progress.completedTasksCount();
        int total = progress.totalTaskCount();
        sumTotal$1.elem += total;
        sumComplete$1.elem += complete;
    }

    public static final /* synthetic */ void $anonfun$getCompletedStages$1(IntRef completed$1, SparkStageProgress progress) {
        int complete = progress.completedTasksCount();
        int total = progress.totalTaskCount();
        if (total > 0 && complete == total) {
            ++completed$1.elem;
            return;
        }
    }

    public SparkProgressMonitor(SparkSession spark, String jobGroup) {
        this.jobGroup = jobGroup;
        this.statusStore = spark.sparkContext().statusStore();
    }
}

