/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.net.jodah.failsafe;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kyuubi.shade.net.jodah.failsafe.AbstractExecution;
import org.apache.kyuubi.shade.net.jodah.failsafe.AsyncExecution;
import org.apache.kyuubi.shade.net.jodah.failsafe.Execution;
import org.apache.kyuubi.shade.net.jodah.failsafe.ExecutionResult;
import org.apache.kyuubi.shade.net.jodah.failsafe.FailsafeException;
import org.apache.kyuubi.shade.net.jodah.failsafe.FailsafeFuture;
import org.apache.kyuubi.shade.net.jodah.failsafe.Functions;
import org.apache.kyuubi.shade.net.jodah.failsafe.Policy;
import org.apache.kyuubi.shade.net.jodah.failsafe.PolicyListeners;
import org.apache.kyuubi.shade.net.jodah.failsafe.event.ExecutionCompletedEvent;
import org.apache.kyuubi.shade.net.jodah.failsafe.function.AsyncRunnable;
import org.apache.kyuubi.shade.net.jodah.failsafe.function.AsyncSupplier;
import org.apache.kyuubi.shade.net.jodah.failsafe.function.CheckedConsumer;
import org.apache.kyuubi.shade.net.jodah.failsafe.function.CheckedRunnable;
import org.apache.kyuubi.shade.net.jodah.failsafe.function.CheckedSupplier;
import org.apache.kyuubi.shade.net.jodah.failsafe.function.ContextualRunnable;
import org.apache.kyuubi.shade.net.jodah.failsafe.function.ContextualSupplier;
import org.apache.kyuubi.shade.net.jodah.failsafe.internal.EventListener;
import org.apache.kyuubi.shade.net.jodah.failsafe.internal.util.Assert;
import org.apache.kyuubi.shade.net.jodah.failsafe.util.concurrent.Scheduler;

public class FailsafeExecutor<R>
extends PolicyListeners<FailsafeExecutor<R>, R> {
    private Scheduler scheduler = Scheduler.DEFAULT;
    final List<Policy<R>> policies;
    private EventListener completeListener;

    FailsafeExecutor(List<Policy<R>> policies) {
        this.policies = policies;
    }

    public <T extends R> T get(CheckedSupplier<T> supplier) {
        return this.call(execution -> Assert.notNull(supplier, "supplier"));
    }

    public <T extends R> T get(ContextualSupplier<T, T> supplier) {
        return this.call(execution -> Functions.toSupplier(supplier, execution));
    }

    public <T extends R> CompletableFuture<T> getAsync(CheckedSupplier<T> supplier) {
        return this.callAsync(execution -> Functions.getPromise(Functions.toCtxSupplier(supplier), execution), false);
    }

    public <T extends R> CompletableFuture<T> getAsync(ContextualSupplier<T, T> supplier) {
        return this.callAsync(execution -> Functions.getPromise(supplier, execution), false);
    }

    public <T extends R> CompletableFuture<T> getAsyncExecution(AsyncRunnable<T> runnable) {
        return this.callAsync(execution -> Functions.getPromiseExecution(runnable, execution), true);
    }

    public <T extends R> CompletableFuture<T> getStageAsync(CheckedSupplier<? extends CompletionStage<T>> supplier) {
        return this.callAsync(execution -> Functions.getPromiseOfStage(Functions.toCtxSupplier(supplier), execution), false);
    }

    public <T extends R> CompletableFuture<T> getStageAsync(ContextualSupplier<T, ? extends CompletionStage<T>> supplier) {
        return this.callAsync(execution -> Functions.getPromiseOfStage(supplier, execution), false);
    }

    public <T extends R> CompletableFuture<T> getStageAsyncExecution(AsyncSupplier<T, ? extends CompletionStage<T>> supplier) {
        return this.callAsync(execution -> Functions.getPromiseOfStageExecution(supplier, execution), true);
    }

    public void run(CheckedRunnable runnable) {
        this.call(execution -> Functions.toSupplier(runnable));
    }

    public void run(ContextualRunnable runnable) {
        this.call(execution -> Functions.toSupplier(runnable, execution));
    }

    public CompletableFuture<Void> runAsync(CheckedRunnable runnable) {
        return this.callAsync(execution -> Functions.getPromise(Functions.toCtxSupplier(runnable), execution), false);
    }

    public CompletableFuture<Void> runAsync(ContextualRunnable runnable) {
        return this.callAsync(execution -> Functions.getPromise(Functions.toCtxSupplier(runnable), execution), false);
    }

    public CompletableFuture<Void> runAsyncExecution(AsyncRunnable<Void> runnable) {
        return this.callAsync(execution -> Functions.getPromiseExecution(runnable, execution), true);
    }

    public FailsafeExecutor<R> onComplete(CheckedConsumer<? extends ExecutionCompletedEvent<R>> listener) {
        this.completeListener = EventListener.of(Assert.notNull(listener, "listener"));
        return this;
    }

    @Override
    public FailsafeExecutor<R> onFailure(CheckedConsumer<? extends ExecutionCompletedEvent<R>> listener) {
        return (FailsafeExecutor)super.onFailure(listener);
    }

    @Override
    public FailsafeExecutor<R> onSuccess(CheckedConsumer<? extends ExecutionCompletedEvent<R>> listener) {
        return (FailsafeExecutor)super.onSuccess(listener);
    }

    void handleComplete(ExecutionResult result, AbstractExecution<R> execution) {
        if (this.successListener != null && result.getSuccessAll()) {
            this.successListener.handle(result, execution);
        } else if (this.failureListener != null && !result.getSuccessAll()) {
            this.failureListener.handle(result, execution);
        }
        if (this.completeListener != null) {
            this.completeListener.handle(result, execution);
        }
    }

    public FailsafeExecutor<R> with(ScheduledExecutorService executor) {
        this.scheduler = Scheduler.of(executor);
        return this;
    }

    public FailsafeExecutor<R> with(Executor executor) {
        this.scheduler = Scheduler.of(executor);
        return this;
    }

    public FailsafeExecutor<R> with(Scheduler scheduler) {
        this.scheduler = Assert.notNull(scheduler, "scheduler");
        return this;
    }

    private <T> T call(Function<Execution<T>, CheckedSupplier<T>> supplierFn) {
        Execution execution = new Execution(this);
        Supplier<ExecutionResult> supplier = Functions.get(supplierFn.apply(execution), execution);
        ExecutionResult result = execution.executeSync(supplier);
        Throwable failure = result.getFailure();
        if (failure != null) {
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
            if (failure instanceof Error) {
                throw (Error)failure;
            }
            throw new FailsafeException(failure);
        }
        return (T)result.getResult();
    }

    private <T> CompletableFuture<T> callAsync(Function<AsyncExecution<T>, Supplier<CompletableFuture<ExecutionResult>>> supplierFn, boolean asyncExecution) {
        FailsafeFuture future = new FailsafeFuture(this);
        AsyncExecution execution = new AsyncExecution(this.scheduler, future, this);
        future.inject(execution);
        execution.inject(supplierFn.apply(execution), asyncExecution);
        execution.executeAsync(asyncExecution);
        return future;
    }
}

