/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.net.impl.transport;

import java.util.concurrent.ThreadFactory;
import org.apache.kyuubi.shade.io.netty.bootstrap.ServerBootstrap;
import org.apache.kyuubi.shade.io.netty.channel.Channel;
import org.apache.kyuubi.shade.io.netty.channel.ChannelFactory;
import org.apache.kyuubi.shade.io.netty.channel.EventLoopGroup;
import org.apache.kyuubi.shade.io.netty.channel.ServerChannel;
import org.apache.kyuubi.shade.io.netty.channel.kqueue.KQueue;
import org.apache.kyuubi.shade.io.netty.channel.kqueue.KQueueChannelOption;
import org.apache.kyuubi.shade.io.netty.channel.kqueue.KQueueDatagramChannel;
import org.apache.kyuubi.shade.io.netty.channel.kqueue.KQueueDomainSocketChannel;
import org.apache.kyuubi.shade.io.netty.channel.kqueue.KQueueEventLoopGroup;
import org.apache.kyuubi.shade.io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import org.apache.kyuubi.shade.io.netty.channel.kqueue.KQueueServerSocketChannel;
import org.apache.kyuubi.shade.io.netty.channel.kqueue.KQueueSocketChannel;
import org.apache.kyuubi.shade.io.netty.channel.socket.DatagramChannel;
import org.apache.kyuubi.shade.io.netty.channel.socket.InternetProtocolFamily;
import org.apache.kyuubi.shade.io.netty.channel.unix.DomainSocketAddress;
import org.apache.kyuubi.shade.io.vertx.core.datagram.DatagramSocketOptions;
import org.apache.kyuubi.shade.io.vertx.core.net.NetServerOptions;
import org.apache.kyuubi.shade.io.vertx.core.net.SocketAddress;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.SocketAddressImpl;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.transport.Transport;

class KQueueTransport
extends Transport {
    KQueueTransport() {
    }

    @Override
    public java.net.SocketAddress convert(SocketAddress address) {
        if (address.isDomainSocket()) {
            return new DomainSocketAddress(address.path());
        }
        return super.convert(address);
    }

    @Override
    public SocketAddress convert(java.net.SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            return new SocketAddressImpl(((DomainSocketAddress)address).path());
        }
        return super.convert(address);
    }

    @Override
    public boolean isAvailable() {
        return KQueue.isAvailable();
    }

    @Override
    public Throwable unavailabilityCause() {
        return KQueue.unavailabilityCause();
    }

    @Override
    public EventLoopGroup eventLoopGroup(int type, int nThreads, ThreadFactory threadFactory, int ioRatio) {
        KQueueEventLoopGroup eventLoopGroup = new KQueueEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new KQueueDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return new KQueueDatagramChannel();
    }

    @Override
    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            return KQueueDomainSocketChannel::new;
        }
        return KQueueSocketChannel::new;
    }

    @Override
    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            return KQueueServerDomainSocketChannel::new;
        }
        return KQueueServerSocketChannel::new;
    }

    @Override
    public void configure(NetServerOptions options, boolean domainSocket, ServerBootstrap bootstrap) {
        if (!domainSocket) {
            bootstrap.option(KQueueChannelOption.SO_REUSEPORT, options.isReusePort());
        }
        super.configure(options, domainSocket, bootstrap);
    }

    @Override
    public void configure(DatagramChannel channel, DatagramSocketOptions options) {
        channel.config().setOption(KQueueChannelOption.SO_REUSEPORT, options.isReusePort());
        super.configure(channel, options);
    }
}

