/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.grpc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kyuubi.shade.io.grpc.ClientInterceptor;
import org.apache.kyuubi.shade.io.grpc.Internal;
import org.apache.kyuubi.shade.io.grpc.ServerInterceptor;
import org.apache.kyuubi.shade.io.grpc.ServerStreamTracer;

@Internal
final class GlobalInterceptors {
    private static List<ClientInterceptor> clientInterceptors = Collections.emptyList();
    private static List<ServerInterceptor> serverInterceptors = Collections.emptyList();
    private static List<ServerStreamTracer.Factory> serverStreamTracerFactories = Collections.emptyList();
    private static boolean isGlobalInterceptorsTracersSet;
    private static boolean isGlobalInterceptorsTracersGet;

    private GlobalInterceptors() {
    }

    static synchronized void setInterceptorsTracers(List<ClientInterceptor> clientInterceptorList, List<ServerInterceptor> serverInterceptorList, List<ServerStreamTracer.Factory> serverStreamTracerFactoryList) {
        if (isGlobalInterceptorsTracersGet) {
            throw new IllegalStateException("Set cannot be called after any get call");
        }
        if (isGlobalInterceptorsTracersSet) {
            throw new IllegalStateException("Global interceptors and tracers are already set");
        }
        if (clientInterceptorList != null) {
            clientInterceptors = Collections.unmodifiableList(new ArrayList<ClientInterceptor>(clientInterceptorList));
        }
        if (serverInterceptorList != null) {
            serverInterceptors = Collections.unmodifiableList(new ArrayList<ServerInterceptor>(serverInterceptorList));
        }
        if (serverStreamTracerFactoryList != null) {
            serverStreamTracerFactories = Collections.unmodifiableList(new ArrayList<ServerStreamTracer.Factory>(serverStreamTracerFactoryList));
        }
        isGlobalInterceptorsTracersSet = true;
    }

    static synchronized List<ClientInterceptor> getClientInterceptors() {
        isGlobalInterceptorsTracersGet = true;
        return clientInterceptors;
    }

    static synchronized List<ServerInterceptor> getServerInterceptors() {
        isGlobalInterceptorsTracersGet = true;
        return serverInterceptors;
    }

    static synchronized List<ServerStreamTracer.Factory> getServerStreamTracerFactories() {
        isGlobalInterceptorsTracersGet = true;
        return serverStreamTracerFactories;
    }
}

