/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

package org.apache.kylin.metadata.realization;

/**
 */
public class IRealizationConstants {

    public final static String LookupHbaseStorageLocationPrefix = "LOOKUP_";

    /**
     * For each cube htable, we leverage htable's metadata to keep track of
     * which kylin server(represented by its kylin_metadata prefix) owns this htable
     */
    public final static String HTableTag = "KYLIN_HOST";

    public final static String HTableOwner = "OWNER";

    public final static String HTableUser = "USER";

    public final static String HTableCreationTime = "CREATION_TIME";

    public final static String HTableSegmentTag = "SEGMENT";

    public final static String HTableGitTag = "GIT_COMMIT";

}
