/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.authenticator.test;

import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;

public class SimpleTestUsernamePasswordAuthenticator
implements Authenticator<UsernamePasswordCredentials> {
    public void validate(UsernamePasswordCredentials credentials, WebContext context) {
        if (credentials == null) {
            throw new CredentialsException("No credential");
        }
        String username = credentials.getUsername();
        String password = credentials.getPassword();
        if (CommonHelper.isBlank((String)username)) {
            throw new CredentialsException("Username cannot be blank");
        }
        if (CommonHelper.isBlank((String)password)) {
            throw new CredentialsException("Password cannot be blank");
        }
        if (CommonHelper.areNotEquals((String)username, (String)password)) {
            throw new CredentialsException("Username : '" + username + "' does not match password");
        }
        CommonProfile profile = new CommonProfile();
        profile.setId(username);
        profile.addAttribute("username", (Object)username);
        credentials.setUserProfile(profile);
    }
}

