/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.hdfs;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class NameNodeServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "NAMENODE";
    public static final String SERVICE_TYPE = "HDFS";
    public static final String ROLE_TYPE = "NAMENODE";
    static final String DISCOVERY_NAMESERVICE = "nameservice";
    static final String AUTOFAILOVER_ENABLED = "autofailover_enabled";
    static final String NN_NAMESERVICE = "dfs_federation_namenode_nameservice";
    static final String NN_PORT = "namenode_port";

    @Override
    public String getServiceType() {
        return SERVICE_TYPE;
    }

    @Override
    public String getService() {
        return "NAMENODE";
    }

    @Override
    public String getRoleType() {
        return "NAMENODE";
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.API;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig, ApiServiceConfig coreSettingsConfig) throws ApiException {
        String serviceUrl;
        boolean haEnabled = Boolean.parseBoolean(this.getRoleConfigValue(roleConfig, AUTOFAILOVER_ENABLED));
        if (haEnabled) {
            String nameservice = this.getRoleConfigValue(roleConfig, NN_NAMESERVICE);
            serviceUrl = String.format(Locale.getDefault(), "hdfs://%s", nameservice);
        } else {
            String hostname = role.getHostRef().getHostname();
            String port = this.getRoleConfigValue(roleConfig, NN_PORT);
            serviceUrl = String.format(Locale.getDefault(), "hdfs://%s:%s", hostname, port);
        }
        ServiceModel model = this.createServiceModel(serviceUrl);
        model.addRoleProperty(this.getRoleType(), AUTOFAILOVER_ENABLED, this.getRoleConfigValue(roleConfig, AUTOFAILOVER_ENABLED));
        model.addRoleProperty(this.getRoleType(), NN_PORT, this.getRoleConfigValue(roleConfig, NN_PORT));
        if (haEnabled) {
            model.addRoleProperty(this.getRoleType(), NN_NAMESERVICE, this.getRoleConfigValue(roleConfig, NN_NAMESERVICE));
            model.addQualifyingServiceParam(DISCOVERY_NAMESERVICE, model.getRoleProperties().get(this.getRoleType()).get(NN_NAMESERVICE));
        }
        return model;
    }
}

