/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="A time series entity attribute represents a possible attribute of a time series entity type monitored by the Cloudera Management Services. <p> Available since API v11.")
public class ApiTimeSeriesEntityAttribute {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="isValueCaseSensitive")
    private Boolean isValueCaseSensitive = null;

    public ApiTimeSeriesEntityAttribute name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name of the of the attribute. This name uniquely identifies this attribute.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiTimeSeriesEntityAttribute displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(description="Display name of the attribute.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiTimeSeriesEntityAttribute description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of the attribute.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ApiTimeSeriesEntityAttribute isValueCaseSensitive(Boolean isValueCaseSensitive) {
        this.isValueCaseSensitive = isValueCaseSensitive;
        return this;
    }

    @Schema(description="Returns whether to treat attribute values as case-sensitive. Defaults to false.")
    public Boolean isIsValueCaseSensitive() {
        return this.isValueCaseSensitive;
    }

    public void setIsValueCaseSensitive(Boolean isValueCaseSensitive) {
        this.isValueCaseSensitive = isValueCaseSensitive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiTimeSeriesEntityAttribute apiTimeSeriesEntityAttribute = (ApiTimeSeriesEntityAttribute)o;
        return Objects.equals(this.name, apiTimeSeriesEntityAttribute.name) && Objects.equals(this.displayName, apiTimeSeriesEntityAttribute.displayName) && Objects.equals(this.description, apiTimeSeriesEntityAttribute.description) && Objects.equals(this.isValueCaseSensitive, apiTimeSeriesEntityAttribute.isValueCaseSensitive);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.displayName, this.description, this.isValueCaseSensitive);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiTimeSeriesEntityAttribute {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isValueCaseSensitive: ").append(this.toIndentedString(this.isValueCaseSensitive)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

