/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message.controls;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.message.controls.AbstractControl;
import org.apache.directory.api.ldap.model.message.controls.ProxiedAuthz;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;

public class ProxiedAuthzImpl
extends AbstractControl
implements ProxiedAuthz {
    private String authzId;

    public ProxiedAuthzImpl() {
        super("2.16.840.1.113730.3.4.18");
        this.setCritical(true);
    }

    @Override
    public String getAuthzId() {
        return this.authzId;
    }

    @Override
    public void setAuthzId(String authzId) {
        if (authzId == null) {
            throw new RuntimeException(I18n.err((I18n)I18n.ERR_13511_INVALID_PROXIED_AUTHZ_NULL, (Object[])new Object[0]));
        }
        if (!Strings.isEmpty((String)authzId)) {
            String lowercaseAuthzId = Strings.toLowerCaseAscii((String)authzId);
            if (lowercaseAuthzId.startsWith("dn:")) {
                String dn = authzId.substring(3);
                if (!Dn.isValid(dn)) {
                    throw new RuntimeException(I18n.err((I18n)I18n.ERR_13512_INVALID_PROXIED_AUTHZ_BAD_DN, (Object[])new Object[0]));
                }
            } else if (!lowercaseAuthzId.startsWith("u:")) {
                throw new RuntimeException(I18n.err((I18n)I18n.ERR_13513_INVALID_PROXIED_AUTHZ_NO_DN_OR_U, (Object[])new Object[0]));
            }
        }
        this.authzId = authzId;
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        if (this.authzId != null) {
            h = h * 37 + this.authzId.hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProxiedAuthz)) {
            return false;
        }
        ProxiedAuthz otherControl = (ProxiedAuthz)o;
        return super.equals(o) && (this.authzId == otherControl.getAuthzId() || this.authzId != null && this.authzId.equals(otherControl.getAuthzId()));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Proxied Authz Control\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        authzid   : '").append(this.authzId).append("'\n");
        return sb.toString();
    }
}

