/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.monitor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.cm.monitor.AbstractConfigurationStore;
import org.apache.knox.gateway.topology.discovery.cm.monitor.DiscoveryConfigurationStore;

public class DiscoveryConfigurationFileStore
extends AbstractConfigurationStore
implements DiscoveryConfigurationStore {
    private static final String PERSISTED_FILE_COMMENT = "Generated File. Do Not Edit!";
    private static final String PROP_CLUSTER_PREFIX = "cluster.";
    private static final String PROP_CLUSTER_SOURCE = "cluster.source";
    private static final String PROP_CLUSTER_NAME = "cluster.name";
    private static final String PROP_CLUSTER_USER = "cluster.user";
    private static final String PROP_CLUSTER_ALIAS = "cluster.pwd.alias";

    DiscoveryConfigurationFileStore(GatewayConfig gatewayConfig) {
        super(gatewayConfig);
    }

    @Override
    public void store(ServiceDiscoveryConfig config) {
        Path persistenceDir = this.getPersistenceDir();
        if (persistenceDir != null && Files.exists(persistenceDir, new LinkOption[0])) {
            String pwdAlias;
            String address = config.getAddress();
            String cluster = config.getCluster();
            Properties props = new Properties();
            props.setProperty(PROP_CLUSTER_NAME, cluster);
            props.setProperty(PROP_CLUSTER_SOURCE, address);
            String username = config.getUser();
            if (username != null) {
                props.setProperty(PROP_CLUSTER_USER, username);
            }
            if ((pwdAlias = config.getPasswordAlias()) != null) {
                props.setProperty(PROP_CLUSTER_ALIAS, pwdAlias);
            }
            this.persist(props, this.getPersistenceFile(address, cluster));
        }
    }

    @Override
    public Set<ServiceDiscoveryConfig> getAll() {
        HashSet<ServiceDiscoveryConfig> result = new HashSet<ServiceDiscoveryConfig>();
        Path persistenceDir = this.getPersistenceDir();
        if (persistenceDir != null && Files.exists(persistenceDir, new LinkOption[0])) {
            Collection persistedConfigs = FileUtils.listFiles((File)persistenceDir.toFile(), (String[])new String[]{"conf"}, (boolean)false);
            for (File persisted : persistedConfigs) {
                final Properties props = new Properties();
                try {
                    InputStream in = Files.newInputStream(persisted.toPath(), new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        props.load(in);
                        if (StringUtils.isBlank((CharSequence)props.getProperty(PROP_CLUSTER_SOURCE))) {
                            log.missingServiceDiscoveryConfigProperty(PROP_CLUSTER_SOURCE);
                            continue;
                        }
                        if (StringUtils.isBlank((CharSequence)props.getProperty(PROP_CLUSTER_NAME))) {
                            log.missingServiceDiscoveryConfigProperty(PROP_CLUSTER_NAME);
                            continue;
                        }
                        result.add(new ServiceDiscoveryConfig(){

                            public String getAddress() {
                                return props.getProperty(DiscoveryConfigurationFileStore.PROP_CLUSTER_SOURCE);
                            }

                            public String getCluster() {
                                return props.getProperty(DiscoveryConfigurationFileStore.PROP_CLUSTER_NAME);
                            }

                            public String getUser() {
                                return props.getProperty(DiscoveryConfigurationFileStore.PROP_CLUSTER_USER);
                            }

                            public String getPasswordAlias() {
                                return props.getProperty(DiscoveryConfigurationFileStore.PROP_CLUSTER_ALIAS);
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (IOException e) {
                    log.failedToLoadClusterMonitorServiceDiscoveryConfig(this.getMonitorType(), e);
                }
            }
        }
        return result;
    }

    @Override
    protected File getPersistenceFile(String address, String clusterName) {
        return this.getPersistenceFile(address, clusterName.replaceAll(" ", "_"), "conf");
    }

    private void persist(Properties props, File dest) {
        try (OutputStream out = Files.newOutputStream(dest.toPath(), new OpenOption[0]);){
            props.store(out, PERSISTED_FILE_COMMENT);
            out.flush();
        }
        catch (Exception e) {
            log.failedToPersistClusterMonitorData(this.getMonitorType(), dest.getAbsolutePath(), e);
        }
    }
}

