/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.collector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.ServiceURLCollector;

public abstract class AbstractURLCollector
implements ServiceURLCollector {
    @Override
    public List<String> collect(Map<String, List<ServiceModel>> roleModels) {
        List<String> urls;
        if (roleModels.isEmpty()) {
            urls = Collections.emptyList();
        } else if (roleModels.size() == 1) {
            urls = new ArrayList<String>();
            List<ServiceModel> models = roleModels.values().iterator().next();
            urls.addAll(this.getURLs(models));
        } else {
            urls = this.getURLs(roleModels);
        }
        return urls;
    }

    protected List<String> getURLs(Map<String, List<ServiceModel>> roleModels) {
        ArrayList<String> urls = new ArrayList<String>();
        for (List<ServiceModel> models : roleModels.values()) {
            urls.addAll(this.getURLs(models));
        }
        return urls;
    }

    protected List<String> getURLs(List<ServiceModel> roleModels) {
        ArrayList<String> urls = new ArrayList<String>();
        for (ServiceModel model : roleModels) {
            urls.add(model.getServiceUrl());
        }
        return urls;
    }
}

