/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.ad_impl;

import java.util.Set;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Action;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.controls.ad.AdDirSyncResponseFlag;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdDirSyncResponseContainer;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdDirSyncResponseStatesEnum;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdDirSyncResponseGrammar
extends AbstractGrammar<AdDirSyncResponseContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(AdDirSyncResponseGrammar.class);
    private static final AdDirSyncResponseGrammar INSTANCE = new AdDirSyncResponseGrammar();

    private AdDirSyncResponseGrammar() {
        this.setName(AdDirSyncResponseGrammar.class.getName());
        this.transitions = new GrammarTransition[AdDirSyncResponseStatesEnum.LAST_AD_DIR_SYNC_RESPONSE_STATE.ordinal()][256];
        this.transitions[AdDirSyncResponseStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)AdDirSyncResponseStatesEnum.START_STATE, (Enum)AdDirSyncResponseStatesEnum.AD_DIR_SYNC_RESPONSE_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction<AdDirSyncResponseContainer>("Initialization"){

            public void action(AdDirSyncResponseContainer container) throws DecoderException {
            }
        });
        this.transitions[AdDirSyncResponseStatesEnum.AD_DIR_SYNC_RESPONSE_SEQUENCE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)AdDirSyncResponseStatesEnum.AD_DIR_SYNC_RESPONSE_SEQUENCE_STATE, (Enum)AdDirSyncResponseStatesEnum.FLAG_STATE, (int)UniversalTag.INTEGER.getValue(), (Action)new GrammarAction<AdDirSyncResponseContainer>("Set AdDirSyncResponseControl flag"){

            public void action(AdDirSyncResponseContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int flagValue = IntegerDecoder.parse((BerValue)value);
                    Set flags = AdDirSyncResponseFlag.getFlags((int)flagValue);
                    if (flags == null) {
                        String msg = I18n.err((I18n)I18n.ERR_08104_AD_DIR_SYNC_FLAG_DECODING_FAILURE, (Object[])new Object[]{flagValue});
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg((I18n)I18n.MSG_08101_FLAGS, (Object[])new Object[]{flags.toString()}));
                    }
                    container.getAdDirSyncResponseControl().setFlags(flags);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err((I18n)I18n.ERR_08105_AD_DIR_SYNC_FLAG_DECODING_ERROR, (Object[])new Object[]{ide.getMessage()});
                    LOG.error(msg, (Throwable)ide);
                    throw new DecoderException(msg, (Throwable)ide);
                }
            }
        });
        this.transitions[AdDirSyncResponseStatesEnum.FLAG_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)AdDirSyncResponseStatesEnum.FLAG_STATE, (Enum)AdDirSyncResponseStatesEnum.MAX_RETURN_LENGTH_STATE, (int)UniversalTag.INTEGER.getValue(), (Action)new GrammarAction<AdDirSyncResponseContainer>("Set AdDirSyncResponseControl maxReturnLength"){

            public void action(AdDirSyncResponseContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    int maxReturnLength = IntegerDecoder.parse((BerValue)value);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg((I18n)I18n.MSG_08102_MAX_RETURN_LENGTH, (Object[])new Object[]{maxReturnLength}));
                    }
                    container.getAdDirSyncResponseControl().setMaxReturnLength(maxReturnLength);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err((I18n)I18n.ERR_08106_AD_DIR_SYNC_MAX_RETURN_LENGTH_DECODING_ERROR, (Object[])new Object[]{ide.getMessage()});
                    LOG.error(msg, (Throwable)ide);
                    throw new DecoderException(msg, (Throwable)ide);
                }
            }
        });
        this.transitions[AdDirSyncResponseStatesEnum.MAX_RETURN_LENGTH_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)AdDirSyncResponseStatesEnum.MAX_RETURN_LENGTH_STATE, (Enum)AdDirSyncResponseStatesEnum.COOKIE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<AdDirSyncResponseContainer>("Set AdDirSyncResponseControl cookie"){

            public void action(AdDirSyncResponseContainer container) {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_08000_COOKIE, (Object[])new Object[]{Strings.dumpBytes((byte[])cookie)}));
                }
                container.getAdDirSyncResponseControl().setCookie(cookie);
                container.setGrammarEndAllowed(true);
            }
        });
    }

    public static Grammar<AdDirSyncResponseContainer> getInstance() {
        return INSTANCE;
    }
}

