/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChoiceProcessor
extends AsyncProcessorSupport
implements Navigate<Processor>,
Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(ChoiceProcessor.class);
    private String id;
    private String routeId;
    private final List<FilterProcessor> filters;
    private final AsyncProcessor otherwise;
    private transient long notFiltered;

    public ChoiceProcessor(List<FilterProcessor> filters, Processor otherwise) {
        this.filters = filters;
        this.otherwise = AsyncProcessorConverterHelper.convert((Processor)otherwise);
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        final Object existing = exchange.getProperty("CamelFilterMatched");
        AsyncCallback choiceCallback = new AsyncCallback(){

            public void done(boolean doneSync) {
                if (existing != null) {
                    exchange.setProperty("CamelFilterMatched", existing);
                } else {
                    exchange.removeProperty("CamelFilterMatched");
                }
                callback.done(doneSync);
            }
        };
        for (FilterProcessor filter : this.filters) {
            boolean matches = false;
            try {
                matches = filter.matches(exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            if (!PipelineHelper.continueProcessing(exchange, "so breaking out of choice", LOG)) break;
            if (!matches) continue;
            return filter.getProcessor().process(exchange, choiceCallback);
        }
        if (this.otherwise != null) {
            ++this.notFiltered;
            return this.otherwise.process(exchange, choiceCallback);
        }
        choiceCallback.done(true);
        return true;
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        return "choice";
    }

    public List<FilterProcessor> getFilters() {
        return this.filters;
    }

    public Processor getOtherwise() {
        return this.otherwise;
    }

    public long getNotFilteredCount() {
        return this.notFiltered;
    }

    public void reset() {
        for (FilterProcessor filter : this.filters) {
            filter.reset();
        }
        this.notFiltered = 0L;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>();
        if (!this.filters.isEmpty()) {
            answer.addAll(this.filters);
        }
        if (this.otherwise != null) {
            answer.add((Processor)this.otherwise);
        }
        return answer;
    }

    public boolean hasNext() {
        return this.otherwise != null || !this.filters.isEmpty();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    protected void doInit() throws Exception {
        ServiceHelper.initService((Object[])new Object[]{this.filters, this.otherwise});
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object[])new Object[]{this.filters, this.otherwise});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.otherwise, this.filters});
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.otherwise, this.filters});
    }
}

