/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.auth.UserAuth;
import org.apache.sshd.client.auth.UserAuthFactory;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.DefaultAuthFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionHolder;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.auth.UserAuthMethodFactory;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.future.DefaultCancelFuture;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.core.CoreModuleProperties;

public class ClientUserAuthService
extends AbstractCloseable
implements Service,
ClientSessionHolder {
    protected final AtomicReference<AuthFuture> authFutureHolder = new AtomicReference();
    protected final ClientSessionImpl clientSession;
    protected final List<UserAuthFactory> authFactories;
    protected final List<String> clientMethods;
    protected List<String> serverMethods;
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private String service;
    private UserAuth currentUserAuth;
    private int currentMethod;
    private UserAuth pubkeyAuth;
    private final Object initLock = new Object();
    private boolean started;
    private Runnable initialRequestSender;

    public ClientUserAuthService(Session s) {
        this.clientSession = ValidateUtils.checkInstanceOf((Object)s, ClientSessionImpl.class, "Client side service used on server side: %s", (Object)s);
        this.authFactories = ValidateUtils.checkNotNullAndNotEmpty(this.clientSession.getUserAuthFactories(), "No user auth factories for %s", s);
        this.clientMethods = new ArrayList<String>();
        String prefs = CoreModuleProperties.PREFERRED_AUTHS.getOrNull(s);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (GenericUtils.isEmpty(prefs)) {
            for (UserAuthFactory factory : this.authFactories) {
                this.clientMethods.add(factory.getName());
            }
        } else {
            if (debugEnabled) {
                this.log.debug("ClientUserAuthService({}) use configured preferences: {}", (Object)s, (Object)prefs);
            }
            for (String pref : GenericUtils.split(prefs, ',')) {
                UserAuthFactory factory = NamedResource.findByName(pref, String.CASE_INSENSITIVE_ORDER, this.authFactories);
                if (factory != null) {
                    this.clientMethods.add(pref);
                    continue;
                }
                if (!debugEnabled) continue;
                this.log.debug("ClientUserAuthService({}) skip unknown preferred authentication method: {}", (Object)s, (Object)pref);
            }
        }
        if (debugEnabled) {
            this.log.debug("ClientUserAuthService({}) client methods: {}", (Object)s, this.clientMethods);
        }
        this.clientSession.resetAuthTimeout();
    }

    @Override
    public ClientSession getSession() {
        return this.getClientSession();
    }

    @Override
    public ClientSession getClientSession() {
        return this.clientSession;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Runnable initial;
        Object object = this.initLock;
        synchronized (object) {
            this.started = true;
            initial = this.initialRequestSender;
            this.initialRequestSender = null;
        }
        if (initial != null) {
            initial.run();
        }
    }

    public String getCurrentServiceName() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthFuture auth(String service) throws IOException {
        this.service = ValidateUtils.checkNotNullAndNotEmpty(service, "No service name");
        ClientSession session = this.getClientSession();
        AuthFuture authFuture = this.updateCurrentAuthFuture(session, service);
        this.serverMethods = null;
        this.pubkeyAuth = null;
        this.currentMethod = 0;
        this.clearUserAuth();
        Runnable sender = () -> {
            try {
                this.sendInitialAuthRequest(session, service);
            }
            catch (Exception e) {
                authFuture.setException(e);
            }
        };
        Object object = this.initLock;
        synchronized (object) {
            if (!this.started) {
                this.initialRequestSender = sender;
                sender = null;
            }
        }
        if (sender != null) {
            sender.run();
        }
        return authFuture;
    }

    protected AuthFuture updateCurrentAuthFuture(ClientSession session, String service) throws IOException {
        AuthFuture authFuture = this.createAuthFuture(session, service);
        if (!this.authFutureHolder.compareAndSet(null, authFuture)) {
            throw new SshException("Authentication already ongoing");
        }
        return authFuture;
    }

    protected AuthFuture createAuthFuture(ClientSession session, String service) throws IOException {
        return new DefaultAuthFuture(service, this.clientSession.getFutureLock()){

            private void clear() {
                ClientUserAuthService.this.authFutureHolder.compareAndSet(this, null);
            }

            @Override
            protected void onValueSet(Object value) {
                if (!(value instanceof CancelFuture)) {
                    this.clear();
                }
            }

            @Override
            protected CancelFuture createCancellation() {
                return new DefaultCancelFuture(this.getId()){

                    @Override
                    protected void onValueSet(Object value) {
                        this.clear();
                    }
                };
            }
        };
    }

    protected IoWriteFuture sendInitialAuthRequest(ClientSession session, String service) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("auth({})[{}] send SSH_MSG_USERAUTH_REQUEST for 'none'", (Object)session, (Object)service);
        }
        String username = session.getUsername();
        Buffer buffer = session.createBuffer((byte)50, username.length() + service.length() + 32);
        buffer.putString(username);
        buffer.putString(service);
        buffer.putString("none");
        return session.writePacket(buffer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(int cmd, Buffer buffer) throws Exception {
        ClientSession session = this.getClientSession();
        AuthFuture authFuture = this.authFutureHolder.get();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (authFuture != null) {
            if (authFuture.isSuccess()) {
                this.log.error("process({}) unexpected authenticated client command: {}", (Object)session, (Object)SshConstants.getCommandMessageName(cmd));
                throw new IllegalStateException("UserAuth message delivered to authenticated client");
            }
            if (authFuture.isCanceled()) {
                return;
            }
            if (authFuture.isDone()) {
                if (!debugEnabled) return;
                this.log.debug("process({}) Ignoring random message - cmd={}", (Object)session, (Object)SshConstants.getCommandMessageName(cmd));
                return;
            }
        }
        if (cmd == 53) {
            String welcome = buffer.getString();
            String lang = buffer.getString();
            if (debugEnabled) {
                this.log.debug("process({}) Welcome banner(lang={}): {}", new Object[]{session, lang, welcome});
            }
            UserInteraction ui = session.getUserInteraction();
            try {
                if (ui == null || !ui.isInteractionAllowed(session)) return;
                ui.welcome(session, welcome, lang);
                return;
            }
            catch (Error e) {
                this.warn("process({}) failed ({}) to consult interaction: {}", session, e.getClass().getSimpleName(), e.getMessage(), e);
                RuntimeSshException ex = new RuntimeSshException(e);
                if (authFuture == null) throw ex;
                authFuture.setException(ex);
                throw ex;
            }
        } else if (authFuture != null) {
            this.processUserAuth(cmd, buffer, authFuture);
            return;
        } else {
            if (!debugEnabled) return;
            this.log.debug("process({}) Ignoring random message - cmd={}", (Object)session, (Object)SshConstants.getCommandMessageName(cmd));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processUserAuth(int cmd, Buffer buffer, AuthFuture authFuture) throws Exception {
        ClientSession session = this.getClientSession();
        if (cmd == 52) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("processUserAuth({}) SSH_MSG_USERAUTH_SUCCESS Succeeded with {}", (Object)session, (Object)(this.currentUserAuth == null ? "<unknown>" : this.currentUserAuth.getName()));
            }
            if (this.currentUserAuth != null) {
                try {
                    this.currentUserAuth.signalAuthMethodSuccess(session, this.service, buffer);
                }
                finally {
                    this.clearUserAuth();
                }
            } else {
                this.destroyPubkeyAuth();
            }
            session.setAuthenticated();
            ((ClientSessionImpl)session).switchToNextService();
            authFuture.setAuthed(true);
            return;
        }
        authFuture.setCancellable(true);
        if (authFuture.isCanceled()) {
            authFuture.getCancellation().setCanceled();
            this.clearUserAuth();
            return;
        }
        if (cmd == 51) {
            List<String> allowedMethods;
            String methods = buffer.getString();
            boolean partial = buffer.getBoolean();
            if (this.log.isDebugEnabled()) {
                this.log.debug("processUserAuth({}) Received SSH_MSG_USERAUTH_FAILURE - partial={}, methods={}", new Object[]{session, partial, methods});
            }
            if (GenericUtils.isEmpty(methods)) {
                if (this.serverMethods == null) {
                    allowedMethods = new ArrayList<String>(this.clientMethods);
                } else if (partial) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("processUserAuth({}) : potential bug in {} server: SSH_MSG_USERAUTH_FAILURE with partial success after {} authentication, but without continuation methods", new Object[]{session, session.getServerVersion(), this.currentUserAuth != null ? this.currentUserAuth.getName() : "UNKNOWN"});
                    }
                    allowedMethods = this.serverMethods;
                } else {
                    allowedMethods = new ArrayList<String>();
                }
            } else {
                allowedMethods = Arrays.asList(GenericUtils.split(methods, ','));
            }
            if (this.currentUserAuth != null) {
                try {
                    this.currentUserAuth.signalAuthMethodFailure(session, this.service, partial, Collections.unmodifiableList(allowedMethods), buffer);
                }
                catch (Exception e) {
                    this.clearUserAuth();
                    throw e;
                }
                if (allowedMethods.indexOf(this.currentUserAuth.getName()) < 0) {
                    if (this.currentUserAuth == this.pubkeyAuth) {
                        this.currentUserAuth = null;
                    } else {
                        this.destroyUserAuth();
                    }
                }
            }
            if (partial || this.serverMethods == null) {
                this.currentMethod = 0;
            }
            this.serverMethods = allowedMethods;
            this.tryNext(cmd, authFuture);
            return;
        }
        if (this.currentUserAuth == null) {
            throw new IllegalStateException("Received unknown packet: " + SshConstants.getCommandMessageName(cmd));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("processUserAuth({}) delegate processing of {} to {}", new Object[]{session, SshConstants.getCommandMessageName(cmd), this.currentUserAuth.getName()});
        }
        buffer.rpos(buffer.rpos() - 1);
        if (!this.currentUserAuth.process(buffer)) {
            this.tryNext(cmd, authFuture);
        } else {
            authFuture.setCancellable(this.currentUserAuth.isCancellable());
        }
    }

    protected void tryNext(int cmd, AuthFuture authFuture) throws Exception {
        ClientSession session = this.getClientSession();
        boolean debugEnabled = this.log.isDebugEnabled();
        while (true) {
            if (this.currentUserAuth == null) {
                if (debugEnabled) {
                    this.log.debug("tryNext({}) starting authentication mechanisms: client={}, client index={}, server={}", new Object[]{session, this.clientMethods, this.currentMethod, this.serverMethods});
                }
            } else if (!this.currentUserAuth.process(null)) {
                if (debugEnabled) {
                    this.log.debug("tryNext({}) no initial request sent by method={}", (Object)session, (Object)this.currentUserAuth.getName());
                }
                if (this.currentUserAuth == this.pubkeyAuth) {
                    this.currentUserAuth = null;
                } else {
                    this.destroyUserAuth();
                }
                ++this.currentMethod;
            } else {
                if (debugEnabled) {
                    this.log.debug("tryNext({}) successfully processed initial buffer by method={}", (Object)session, (Object)this.currentUserAuth.getName());
                }
                return;
            }
            String method = null;
            while (this.currentMethod < this.clientMethods.size() && !this.serverMethods.contains(method = this.clientMethods.get(this.currentMethod))) {
                ++this.currentMethod;
            }
            if (this.currentMethod >= this.clientMethods.size()) {
                if (debugEnabled) {
                    this.log.debug("tryNext({}) exhausted all methods - client={}, server={}", new Object[]{session, this.clientMethods, this.serverMethods});
                }
                this.clearUserAuth();
                authFuture.setException(new SshException(14, "No more authentication methods available"));
                return;
            }
            authFuture.setCancellable(false);
            if (authFuture.isCanceled()) {
                authFuture.getCancellation().setCanceled();
                this.clearUserAuth();
                return;
            }
            if ("publickey".equals(method) && this.pubkeyAuth != null) {
                this.currentUserAuth = this.pubkeyAuth;
            } else {
                this.currentUserAuth = (UserAuth)UserAuthMethodFactory.createUserAuth(session, this.authFactories, method);
                if (this.currentUserAuth == null) {
                    throw new UnsupportedOperationException("Failed to find a user-auth factory for method=" + method);
                }
            }
            if (debugEnabled) {
                this.log.debug("tryNext({}) attempting method={}", (Object)session, (Object)method);
            }
            if (this.currentUserAuth != this.pubkeyAuth) {
                this.currentUserAuth.init(session, this.service);
            }
            if ("publickey".equals(this.currentUserAuth.getName())) {
                this.pubkeyAuth = this.currentUserAuth;
            }
            authFuture.setCancellable(this.currentUserAuth.isCancellable());
            if (authFuture.isCanceled()) {
                authFuture.getCancellation().setCanceled();
                this.clearUserAuth();
                return;
            }
            debugEnabled = this.log.isDebugEnabled();
        }
    }

    private void clearUserAuth() {
        if (this.currentUserAuth == this.pubkeyAuth) {
            this.pubkeyAuth = null;
            this.destroyUserAuth();
        } else {
            this.destroyUserAuth();
            this.destroyPubkeyAuth();
        }
    }

    private void destroyUserAuth() {
        if (this.currentUserAuth != null) {
            try {
                this.currentUserAuth.destroy();
            }
            finally {
                this.currentUserAuth = null;
            }
        }
    }

    private void destroyPubkeyAuth() {
        if (this.pubkeyAuth != null) {
            try {
                this.pubkeyAuth.destroy();
            }
            finally {
                this.pubkeyAuth = null;
            }
        }
    }

    @Override
    protected void preClose() {
        AuthFuture authFuture = this.authFutureHolder.get();
        if (authFuture != null) {
            authFuture.setException(new SshException("Session is closed"));
        }
        super.preClose();
    }
}

