/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedThrottlingInflightRoutePolicyMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.throttling.ThrottlingInflightRoutePolicy;

@ManagedResource(description="Managed ThrottlingInflightRoutePolicy")
public class ManagedThrottlingInflightRoutePolicy
extends ManagedService
implements ManagedThrottlingInflightRoutePolicyMBean {
    private final ThrottlingInflightRoutePolicy policy;

    public ManagedThrottlingInflightRoutePolicy(CamelContext context, ThrottlingInflightRoutePolicy policy) {
        super(context, (Service)policy);
        this.policy = policy;
    }

    public ThrottlingInflightRoutePolicy getPolicy() {
        return this.policy;
    }

    public int getMaxInflightExchanges() {
        return this.getPolicy().getMaxInflightExchanges();
    }

    public void setMaxInflightExchanges(int maxInflightExchanges) {
        this.getPolicy().setMaxInflightExchanges(maxInflightExchanges);
    }

    public int getResumePercentOfMax() {
        return this.getPolicy().getResumePercentOfMax();
    }

    public void setResumePercentOfMax(int resumePercentOfMax) {
        this.getPolicy().setResumePercentOfMax(resumePercentOfMax);
    }

    public String getScope() {
        return this.getPolicy().getScope().name();
    }

    public void setScope(String scope) {
        this.getPolicy().setScope(ThrottlingInflightRoutePolicy.ThrottlingScope.valueOf((String)scope));
    }

    public String getLoggingLevel() {
        return this.getPolicy().getLoggingLevel().name();
    }

    public void setLoggingLevel(String loggingLevel) {
        LoggingLevel level = LoggingLevel.valueOf((String)loggingLevel);
        this.getPolicy().setLoggingLevel(level);
        this.getPolicy().getLogger().setLevel(level);
    }
}

