/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.file.FilePersistenceManager;
import org.apache.felix.cm.impl.DependencyTracker;
import org.apache.felix.cm.impl.Log;
import org.apache.felix.cm.impl.persistence.MemoryPersistenceManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static final String CM_CONFIG_DIR = "felix.cm.dir";
    private static final String CM_CONFIG_PM = "felix.cm.pm";
    public static final String CM_CONFIG_PLUGINS = "felix.cm.config.plugins";
    private volatile DependencyTracker tracker;
    private volatile ServiceRegistration<PersistenceManager> filepmRegistration;
    private volatile ServiceRegistration<PersistenceManager> memorypmRegistration;

    public void start(BundleContext bundleContext) throws BundleException {
        Log.logger.start(bundleContext);
        ServiceFactory<PersistenceManager> defaultFactory = this.registerFilePersistenceManager(bundleContext);
        this.registerMemoryPersistenceManager(bundleContext);
        try {
            this.tracker = new DependencyTracker(bundleContext, defaultFactory, this.getConfiguredPersistenceManager(bundleContext), this.getConfiguredConfigurationPlugins(bundleContext));
        }
        catch (InvalidSyntaxException iae) {
            Log.logger.log(1, "Cannot create the persistence manager tracker", iae);
            throw new BundleException(iae.getMessage(), (Throwable)iae);
        }
    }

    private String getConfiguredPersistenceManager(BundleContext bundleContext) {
        String configuredPM = bundleContext.getProperty(CM_CONFIG_PM);
        if (configuredPM != null && (configuredPM.isEmpty() || "file".equals(configuredPM))) {
            configuredPM = null;
        }
        return configuredPM;
    }

    private String[] getConfiguredConfigurationPlugins(BundleContext bundleContext) {
        String[] configuredPlugins = null;
        String configuredPls = bundleContext.getProperty(CM_CONFIG_PLUGINS);
        if (configuredPls != null) {
            ArrayList<String> values = new ArrayList<String>();
            configuredPlugins = configuredPls.split(",");
            for (int i = 0; i < configuredPlugins.length; ++i) {
                String v = configuredPlugins[i].trim();
                if (v.isEmpty()) continue;
                values.add(v);
            }
            if (!values.isEmpty()) {
                configuredPlugins = values.toArray(new String[values.size()]);
            }
        }
        return configuredPlugins;
    }

    public void stop(BundleContext bundleContext) {
        Log.logger.stop();
        if (this.tracker != null) {
            this.tracker.stop();
            this.tracker = null;
        }
        this.unregisterFilePersistenceManager();
        this.unregisterMemoryPersistenceManager();
    }

    private ServiceFactory<PersistenceManager> registerFilePersistenceManager(final BundleContext bundleContext) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.description", "Platform Filesystem Persistence Manager");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("service.ranking", Integer.MIN_VALUE);
        ((Dictionary)props).put("name", "file");
        ServiceFactory<PersistenceManager> factory = new ServiceFactory<PersistenceManager>(){
            private volatile FilePersistenceManager fpm;

            public PersistenceManager getService(Bundle bundle, ServiceRegistration<PersistenceManager> registration) {
                if (this.fpm == null) {
                    this.fpm = new FilePersistenceManager(bundleContext, bundleContext.getProperty(Activator.CM_CONFIG_DIR));
                }
                return this.fpm;
            }

            public void ungetService(Bundle bundle, ServiceRegistration<PersistenceManager> registration, PersistenceManager service) {
            }
        };
        this.filepmRegistration = bundleContext.registerService(PersistenceManager.class, (ServiceFactory)factory, props);
        return factory;
    }

    private void registerMemoryPersistenceManager(BundleContext bundleContext) {
        MemoryPersistenceManager mpm = new MemoryPersistenceManager();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Platform Memory Persistence Manager");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("name", "memory");
        this.memorypmRegistration = bundleContext.registerService(PersistenceManager.class, (Object)mpm, props);
    }

    private void unregisterFilePersistenceManager() {
        if (this.filepmRegistration != null) {
            this.filepmRegistration.unregister();
            this.filepmRegistration = null;
        }
    }

    private void unregisterMemoryPersistenceManager() {
        if (this.memorypmRegistration != null) {
            this.memorypmRegistration.unregister();
            this.memorypmRegistration = null;
        }
    }

    public static String getLocation(final Bundle bundle) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return bundle.getLocation();
                }
            });
        }
        return bundle.getLocation();
    }
}

