/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.STEUtil;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

public class PackagingDataCalculator {
    static final StackTraceElementProxy[] STEP_ARRAY_TEMPLATE = new StackTraceElementProxy[0];
    HashMap<String, ClassPackagingData> cache = new HashMap();
    private static boolean GET_CALLER_CLASS_METHOD_AVAILABLE = false;
    private static final PackagingDataStrategy[] dataStrategies;

    public void calculate(IThrowableProxy tp) {
        while (tp != null) {
            this.populateFrames(tp.getStackTraceElementProxyArray());
            IThrowableProxy[] suppressed = tp.getSuppressed();
            if (suppressed != null) {
                for (IThrowableProxy current : suppressed) {
                    this.populateFrames(current.getStackTraceElementProxyArray());
                }
            }
            tp = tp.getCause();
        }
    }

    void populateFrames(StackTraceElementProxy[] stepArray) {
        Throwable t = new Throwable("local stack reference");
        StackTraceElement[] localSTEArray = t.getStackTrace();
        int commonFrames = STEUtil.findNumberOfCommonFrames(localSTEArray, stepArray);
        int localFirstCommon = localSTEArray.length - commonFrames;
        int stepFirstCommon = stepArray.length - commonFrames;
        ClassLoader lastExactClassLoader = null;
        ClassLoader firsExactClassLoader = null;
        int missfireCount = 0;
        for (int i = 0; i < commonFrames; ++i) {
            ClassPackagingData pi;
            Class callerClass = null;
            if (GET_CALLER_CLASS_METHOD_AVAILABLE) {
                // empty if block
            }
            StackTraceElementProxy step = stepArray[stepFirstCommon + i];
            String stepClassname = step.ste.getClassName();
            if (callerClass != null && stepClassname.equals(callerClass.getName())) {
                lastExactClassLoader = callerClass.getClassLoader();
                if (firsExactClassLoader == null) {
                    firsExactClassLoader = lastExactClassLoader;
                }
                pi = this.calculateByExactType(callerClass);
                step.setClassPackagingData(pi);
                continue;
            }
            ++missfireCount;
            pi = this.computeBySTEP(step, lastExactClassLoader);
            step.setClassPackagingData(pi);
        }
        this.populateUncommonFrames(commonFrames, stepArray, firsExactClassLoader);
    }

    void populateUncommonFrames(int commonFrames, StackTraceElementProxy[] stepArray, ClassLoader firstExactClassLoader) {
        int uncommonFrames = stepArray.length - commonFrames;
        for (int i = 0; i < uncommonFrames; ++i) {
            StackTraceElementProxy step = stepArray[i];
            ClassPackagingData pi = this.computeBySTEP(step, firstExactClassLoader);
            step.setClassPackagingData(pi);
        }
    }

    private ClassPackagingData calculateByExactType(Class<?> type) {
        String className = type.getName();
        ClassPackagingData cpd = this.cache.get(className);
        if (cpd != null) {
            return cpd;
        }
        return this.makePackagingFromType(type, className);
    }

    private ClassPackagingData computeBySTEP(StackTraceElementProxy step, ClassLoader lastExactClassLoader) {
        String className = step.ste.getClassName();
        ClassPackagingData cpd = this.cache.get(className);
        if (cpd != null) {
            return cpd;
        }
        Class<?> type = this.bestEffortLoadClass(lastExactClassLoader, className);
        return this.makePackagingFromType(type, className);
    }

    private ClassPackagingData makePackagingFromType(Class<?> type, String className) {
        ClassPackagingData cpd = null;
        if (type != null) {
            PackagingDataStrategy strategy;
            PackagingDataStrategy[] packagingDataStrategyArray = dataStrategies;
            int n = packagingDataStrategyArray.length;
            for (int i = 0; i < n && (cpd = (strategy = packagingDataStrategyArray[i]).makePackagingFromType(type, className)) == null; ++i) {
            }
        }
        if (cpd == null) {
            cpd = new ClassPackagingData("na", "na");
        }
        this.cache.put(className, cpd);
        return cpd;
    }

    static String getImplementationVersion(Class<?> type) {
        if (type == null) {
            return "na";
        }
        Package aPackage = type.getPackage();
        if (aPackage != null) {
            String v = aPackage.getImplementationVersion();
            if (v == null) {
                return "na";
            }
            return v;
        }
        return "na";
    }

    static String getCodeLocation(Class<?> type) {
        try {
            URL resource;
            CodeSource codeSource;
            if (type != null && (codeSource = type.getProtectionDomain().getCodeSource()) != null && (resource = codeSource.getLocation()) != null) {
                String locationStr = resource.toString();
                String result = PackagingDataCalculator.getCodeLocation(locationStr, '/');
                if (result != null) {
                    return result;
                }
                return PackagingDataCalculator.getCodeLocation(locationStr, '\\');
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "na";
    }

    private static String getCodeLocation(String locationStr, char separator) {
        int idx = locationStr.lastIndexOf(separator);
        if (PackagingDataCalculator.isFolder(idx, locationStr)) {
            idx = locationStr.lastIndexOf(separator, idx - 1);
            return locationStr.substring(idx + 1);
        }
        if (idx > 0) {
            return locationStr.substring(idx + 1);
        }
        return null;
    }

    private static boolean isFolder(int idx, String text) {
        return idx != -1 && idx + 1 == text.length();
    }

    private Class<?> loadClass(ClassLoader cl, String className) {
        if (cl == null) {
            return null;
        }
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e1) {
            return null;
        }
        catch (NoClassDefFoundError e1) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Class<?> bestEffortLoadClass(ClassLoader lastGuaranteedClassLoader, String className) {
        Class<?> result = this.loadClass(lastGuaranteedClassLoader, className);
        if (result != null) {
            return result;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != lastGuaranteedClassLoader) {
            result = this.loadClass(tccl, className);
        }
        if (result != null) {
            return result;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e1) {
            return null;
        }
        catch (NoClassDefFoundError e1) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        ArrayList<PackagingDataStrategy> strategies = new ArrayList<PackagingDataStrategy>();
        try {
            strategies.add(new OsgiPackagingDataStrategy());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        strategies.add(new DefaultPackagingDataStrategy());
        dataStrategies = strategies.toArray(new PackagingDataStrategy[0]);
    }

    private static final class OsgiPackagingDataStrategy
    implements PackagingDataStrategy {
        private OsgiPackagingDataStrategy() {
        }

        @Override
        public ClassPackagingData makePackagingFromType(Class<?> type, String className) {
            try {
                Bundle bundle = FrameworkUtil.getBundle(type);
                if (bundle != null) {
                    Version bundleVersion = bundle.getVersion();
                    String version = bundleVersion == Version.emptyVersion ? "na" : bundleVersion.toString();
                    String codeLocation = bundle.getSymbolicName();
                    return new ClassPackagingData(codeLocation, version);
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return null;
        }
    }

    private static final class DefaultPackagingDataStrategy
    implements PackagingDataStrategy {
        private DefaultPackagingDataStrategy() {
        }

        @Override
        public ClassPackagingData makePackagingFromType(Class<?> type, String className) {
            String version = PackagingDataCalculator.getImplementationVersion(type);
            String codeLocation = PackagingDataCalculator.getCodeLocation(type);
            return new ClassPackagingData(codeLocation, version);
        }
    }

    public static interface PackagingDataStrategy {
        public ClassPackagingData makePackagingFromType(Class<?> var1, String var2);
    }
}

