/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.util;

import java.lang.reflect.InvocationTargetException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.Constants;
import org.osgi.framework.FrameworkUtil;

public class OsgiUtil {
    private static final int OSGI_1_0 = 10;
    private static final int OSGI_1_1 = 11;
    private static final int OSGI_1_2 = 12;
    private static final int OSGI_1_3 = 13;
    private static final int OSGI_1_4 = 14;
    private static final int OSGI_1_5 = 15;
    private static final int OSGI_1_6 = 16;
    private static final int osgiVersion;

    private OsgiUtil() {
    }

    public static String getBundleSymbolicName(Bundle bundle) {
        if (osgiVersion >= 13) {
            return bundle.getSymbolicName();
        }
        return (String)bundle.getHeaders().get("Bundle-SymbolicName");
    }

    public static String getVersion(Bundle bundle) {
        if (osgiVersion >= 15) {
            return bundle.getVersion().toString();
        }
        return (String)bundle.getHeaders().get("Bundle-Version");
    }

    public static Class loadClass(ClassLoader loader, String className) throws ClassNotFoundException {
        if (loader == null || osgiVersion >= 15 && !OsgiUtil.checkValidLoader(loader)) {
            throw new ClassNotFoundException(className);
        }
        return loader.loadClass(className);
    }

    private static boolean checkValidLoader(ClassLoader loader) throws ClassNotFoundException {
        if (loader instanceof BundleReference) {
            Bundle b = ((BundleReference)loader).getBundle();
            if (b == null || b.getState() == 2 || b.getState() == 1) {
                return false;
            }
            if (b.getHeaders().get("DynamicImport-Package") != null) {
                return false;
            }
        }
        return true;
    }

    public static Bundle getBundleOrNull(Class cls) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (osgiVersion >= 15) {
            return FrameworkUtil.getBundle((Class)cls);
        }
        return null;
    }

    static {
        int version;
        try {
            Bundle.class.getMethod("getDataFile", String.class);
            version = 16;
        }
        catch (Throwable t1) {
            try {
                Bundle.class.getMethod("getVersion", new Class[0]);
                version = 15;
            }
            catch (Throwable t2) {
                try {
                    Bundle.class.getMethod("getBundleContext", new Class[0]);
                    version = 14;
                }
                catch (Throwable t3) {
                    try {
                        Bundle.class.getMethod("getLastModified", new Class[0]);
                        version = 13;
                    }
                    catch (Throwable t4) {
                        try {
                            Constants.class.getField("DYNAMICIMPORT_PACKAGE");
                            version = 12;
                        }
                        catch (Throwable t5) {
                            try {
                                Bundle.class.getMethod("getResource", String.class);
                                version = 11;
                            }
                            catch (Throwable t6) {
                                version = 10;
                            }
                        }
                    }
                }
            }
        }
        osgiVersion = version;
    }
}

