/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.util.process.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="shell", name="exec", description="Executes system processes.")
@Service
public class ExecuteAction
implements Action {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Argument(index=0, name="command", description="Execution command with arguments", required=true, multiValued=true)
    private List<String> args;

    public Object execute() throws Exception {
        ProcessBuilder builder = new ProcessBuilder(this.args);
        PumpStreamHandler handler = new PumpStreamHandler(System.in, System.out, System.err, "Command" + this.args.toString());
        this.log.debug("Executing: {}", builder.command());
        Process p = builder.start();
        handler.attach(p);
        handler.start();
        this.log.debug("Waiting for process to exit...");
        int status = p.waitFor();
        this.log.debug("Process exited w/status: {}", (Object)status);
        handler.stop();
        return null;
    }
}

